//
// Navigation tool-ribbon implementation
//
// $Id: navi-toolribbon.js,v 1.9 2011/05/02 12:42:55 rishitani Exp $
//

if (!("NaviToolRibbon" in cuemolui)) {

cuemolui.NaviToolRibbon = ( function() {

// constructor
var ctor = function (aIdBase)
{
  this.mParent = null;
  this.name = aIdBase;
  this.mTabId = aIdBase+"-ribbon-tab";
  this.mTabPanelId = aIdBase+"-ribbon-tabpanel";
  
  // attach to the load/unload event for the target document/window
  var that = this;
  window.addEventListener("load", function(){that.onLoad();}, false);
  // aWindow.addEventListener("unload", function() {that.onUnLoad();}, false);

  // default: navigation (arrow) mode
  this.mCurMode = 1;
}

var klass = ctor.prototype;

//////

// private initialization routine
klass.onLoad = function ()
{
  var that = this;

  document.getElementById("navi-ribbon-arrowbtn").addEventListener(
    "command", function (a) { that.onRadioBtn(a); }, false);
  document.getElementById("navi-ribbon-rectbtn").addEventListener(
    "command", function (a) { that.onRadioBtn(a); }, false);

  this.mCtxtMenuAtomLabel = document.getElementById("navi-ctxtmenu-atomlabel");
  this.mCtxtMenu = document.getElementById("navi-ctxtmenu");

  this.mCtxtMenuSymmLabel = document.getElementById("navi-ctxtmenu-symmlabel");
  this.mCtxtMenuSymm = document.getElementsByClassName("ctxtmenu-symm");

  this.mCtxtMenu.addEventListener("command", function (aEvent) {
    try { that.onCtxtMenu(aEvent) } catch (e) { debug.exception(e) }
  },false);
}

klass.onRadioBtn = function (aEvent)
{
  var sel = null;
  switch (aEvent.target.id) {
  case "navi-ribbon-arrowbtn":
    sel = 1;
    break;
  case "navi-ribbon-rectbtn":
    sel = 2;
    break;
  }

  if (sel==this.mCurMode)
    return;

  this.mCurMode = sel;

  if (this.mCurMode==2)
    this.enableRectTool();
  else
    this.disableRectTool();
}

klass.onActivated = function ()
{
  dd("Navi Tool activated");
  if (this.mCurMode==2)
    this.enableRectTool();
}

klass.onInactivated = function ()
{
  dd("Navi Tool activated");
  if (this.mCurMode==2)
    this.disableRectTool();
}

klass.mouseDragStart = function (x, y, mod)
{
  if (!(mod&(1<<3)))
    return false;
  dd("mouseDragStart");
  if (this.mDrawObj) {
    this.mDrawObj.start(x,y);
    if (this.mView)
      this.mView.invalidate();
  }
  return true;
}
klass.mouseDragMove = function (x, y, mod)
{
  if (!(mod&(1<<3)))
    return false;
  dd("mouseDragMove");
  if (this.mDrawObj) {
    this.mDrawObj.move(x,y);
    if (this.mView)
      this.mView.invalidate();
  }
  return true;
}
klass.mouseDragEnd = function (x, y, mod)
{
  if (!(mod&(1<<3)))
    return false;

  try {
    dd("mouseDragEnd");
    if (this.mDrawObj) {
      this.mDrawObj.end();
      this.rectSel(this.mDrawObj.left, this.mDrawObj.top,
                   this.mDrawObj.width, this.mDrawObj.height);
      if (this.mView)
        this.mView.invalidate();
    }
  }
  catch (e) {
    debug.exception(e);
  }
  return true;
}

klass.rectSel = function (left, top, width, height)
{
  if (!this.mView)
    return;
  var sres = this.mView.hitTestRect(left, top, width, height, true);
  if (sres.length==0)
    return;

  try {
    res = JSON.parse(sres);
  }
  catch (e) {
    dd("error : "+sres);
    debug.exception(e);
    return;
  }

  dd("HittestRect : "+sres);
  var byresid = false;

  var nrend = res.length;
  var selset = new Object();
  for (var i=0; i<nrend; ++i) {
    var elem = res[i];

    var obj_id = elem.obj_id;
    if (!(obj_id in selset))
      selset[obj_id] = new Array();
    selset[obj_id].push(elem.sel);
  }

  var scene = this.mView.getScene();

  // EDIT TXN START //
  scene.startUndoTxn("Select atom(s)");

  var selstr;
  try {
    for (var i in selset) {
      var obj = cuemol.getObject(i);
      if (!('sel' in obj))
        continue;

      selstr = selset[i].join("|");
      dd("selection for Mol["+i+"] : "+selstr);
      obj.sel = cuemol.makeSel(selstr);

    }
  }
  catch(e) {
    dd("SetProp error");
    debug.exception(e);
    scene.rollbackUndoTxn();
    delete scene;
    return;
  }
  
  scene.commitUndoTxn();
  // EDIT TXN END //

  // Save to selHistory
  util.selHistory.append(selstr);
  
  delete scene;
}

klass.enableRectTool = function ()
{
  var view = this.mParent.getTgtView();
  if (!view)
    return;
  var viewid = view.uid;

  var that = this;
  this.mCallbkID1 = cuemol.evtMgr.addListener(
    "mouseDragStart",
    cuemol.evtMgr.SEM_INDEV, // target type
    cuemol.evtMgr.SEM_ANY, // event type
    viewid, // source uid
    function (args) {
      return that.mouseDragStart(args.obj.x, args.obj.y, args.obj.mod);
    });
  this.mCallbkID2 = cuemol.evtMgr.addListener(
    "mouseDragMove",
    cuemol.evtMgr.SEM_INDEV, // target type
    cuemol.evtMgr.SEM_ANY, // event type
    viewid, // source uid
    function (args) {
      return that.mouseDragMove(args.obj.x, args.obj.y, args.obj.mod);
    });
  this.mCallbkID3 = cuemol.evtMgr.addListener(
    "mouseDragEnd",
    cuemol.evtMgr.SEM_INDEV, // target type
    cuemol.evtMgr.SEM_ANY, // event type
    viewid, // source uid
    function (args) {
      return that.mouseDragEnd(args.obj.x, args.obj.y, args.obj.mod);
    });
  
  this.mDrawObj = view.getDrawObj("RectSelDrawObj");
  //this.xxx = view.getDrawObj("RectSelDrawObj");
  //this.mDrawObj = null;

  if (!this.mDrawObj) {
    delete view;
    return;
  }

  this.mDrawObj.enabled = true;
  this.mView = view;
  // this.mView = null;
  delete view;
}

klass.disableRectTool = function ()
{
  this.mView = null;
  cuemol.evtMgr.removeListener(this.mCallbkID1);
  this.mCallbkID1 = null;
  cuemol.evtMgr.removeListener(this.mCallbkID2);
  this.mCallbkID2 = null;
  cuemol.evtMgr.removeListener(this.mCallbkID3);
  this.mCallbkID3 = null;

  if (!this.mDrawObj)
    return;
  this.mDrawObj.enabled = false;
  this.mDrawObj = null;
}

klass.onCtxtMenu = function (aEvent)
{
  var tgtid = aEvent.target.id;
  switch (tgtid) {
  case "navi-ctxtmenu-centerat": 
    try { this.mParent.centerAtomAt(); } catch (e) { debug.exception(e); }
    return;

  case "navi-ctxtmenu-selectatom":
    this.vcmSelectMol(0);
    return;

  case "navi-ctxtmenu-selectresid":
    this.vcmSelectMol(1);
    return;

  case "navi-ctxtmenu-selectchain":
    this.vcmSelectMol(2);
    return;

  case "navi-ctxtmenu-selectmol":
    this.vcmSelectMol(3);
    return;

  case "navi-ctxtmenu-addselectatom":
    this.vcmAddSelectMol(0);
    return;

  case "navi-ctxtmenu-addselectresid":
    this.vcmAddSelectMol(1);
    return;

  case "navi-ctxtmenu-addselectchain":
    this.vcmAddSelectMol(2);
    return;

  case "navi-ctxtmenu-unselectmol":
    this.vcmUnSelectMol();
    return;

  case "navi-ctxtmenu-invertmolsel":
      this.vcmInvertMolSel();
      return;

  case "navi-ctxtmenu-centerat-symm":
    this.centerSymmAtomAt();
    return;

  case "navi-ctxtmenu-create-symm":
    this.createSymmObj();
    return;

  default:
    dd("NaviTool> unknown menu id="+tgtid);
    return;
  }
}

klass.onMouseClicked = function (x, y, mod)
{
  dd("NaviTool> mouse clicked");

  var res = this.mParent.getHittestRes(x, y);
  if (!res)
    return;
  
  if (res.objtype=="MolCoord") {
    if (mod&(1<<5)) { // rbtn
      this.mCtxtMenuAtomLabel.label
	= ( (res.obj_name) ? (res.obj_name+": "):"" ) + res.message;

      if (res.rendtype=="*symm") {
	this.mCtxtMenuSymmLabel.label = " (symop: "+res.symm_name+")";
        this.showSymmCtxtMenu(true);
      }
      else {
        this.showSymmCtxtMenu(false);
      }
      
      this.mCtxtMenu.openPopup(this.mParent.mMainWnd.mPanelContainer.selectedPanel,
                               "overlap", x+2, y+2, true, false);
    }
    else {
      var msg2 = ", O: "+res.occ+" B: "+res.bfac+" Pos: ("+res.x+", "+res.y+", "+res.z+")";
      if (res.rendtype=="*symm")
	gQm2Main.mStatusLabel.label = "Molecule ["+res.obj_name+"], " +
	  res.message + msg2 +
	    " (symop: "+res.symm_name+")";
      else 
	gQm2Main.mStatusLabel.label = "Molecule ["+res.obj_name+"], " +
	  res.message + msg2;
      this.showAtomLabel(res.obj_id, res.atom_id);
    }
  
  }

  return;
}

/// Hide/show symm context menu
klass.showSymmCtxtMenu = function (aShow)
{
  Array.forEach(this.mCtxtMenuSymm, function (e) {
    e.hidden = !aShow;
  } );
}

klass.centerSymmAtomAt = function()
{
  var res = this.mParent.getHittestRes();
  var obj = cuemol.getObject(res.obj_id);
  var rend = cuemol.getRenderer(res.rend_id);

  ////

  var atom = obj.getAtomByID(res.atom_id);
  var pos = atom.pos;
  var symid = res.symm_id;

  // perform transformation of coord by symop
  var matrix = rend.getXformMatrix(symid);
  pos.w = 1.0; // this is important!!
  pos = matrix.mulvec(pos);

  var view = this.mParent.mMainWnd.currentViewW;
  view.setViewCenter(pos);
  
  // cleanup the consumed hittest result
  this.mCurHittestRes = null;
}

klass.createSymmObj = function ()
{
  var scene = this.mParent.mMainWnd.currentSceneW;

  var res = this.mParent.getHittestRes();
  var mol = cuemol.getObject(res.obj_id);
  var rend = cuemol.getRenderer(res.rend_id);
  var matrix = rend.getXformMatrix( res.symm_id );

  var newname = mol.name + " " + res.symm_name;

  /////////

  var data  = Array();
  var i = 0;
  data[i] = Object();
  //data[i].uid = uid;
  data[i].name = newname;
  data[i].rend_types = mol.searchCompatibleRendererNames();
  data[i].obj_type = mol._wrapped.getClassName();

  var result = gQm2Main.doSetupRendDlg({
  target: data, sceneID: scene.uid, ok: false, bEditObjName : true });

  if (!result.ok)
    return;

  ///

  // Copy and transformation can be done out of undo txn
  var selall = cuemol.makeSel("*");
  var newmol = cuemol.createObj("MolCoord");
  newmol.name = data[0].name;
  newmol.copyAtoms(mol, selall);
  newmol.xformByMat(matrix, selall);

  // EDIT TXN START //
  scene.startUndoTxn("Create symm mol");
  try {
    scene.addObject(newmol);

    result.obj_id = newmol.uid;
    gQm2Main.doSetupRend(scene, result);
  }
  catch (e) {
    debug.exception(e);
    
    this.mPrompts.alert(window, document.title,
                        "Create symm mol failed: "+e.message);
    scene.rollbackUndoTxn();
    return;
  }
  scene.commitUndoTxn();
  // EDIT TXN END //

  // cleanup the consumed hittest result
  this.mCurHittestRes = null;
}

/// get selstr form hittest result
klass.getSelstrFromHitRes = function(mode)
{
  var res = this.mParent.getHittestRes();
  if (!res)
    return null;

  var obj = cuemol.getObject(res.obj_id);
  if (!obj) return null;
  var atom = obj.getAtomByID(res.atom_id);
  if (!atom) return null;

  var selstr;

  switch (mode) {
  case 0:
    // atom
    selstr = "aid "+res.atom_id;
    break;

  case 1:
    // residue
    var chname = atom.chainName;
    var resind = atom.residIndex;
    selstr = chname + "." + resind + ".*";
    break;

  case 2:
    // chain
    var chname = atom.chainName;
    //var resind = atom.residIndex;
    selstr = "c;"+chname;
    break;

  case 3:
  default:
    // mol
    selstr = "*";
    
    break;
  }

  return selstr;
}

klass.vcmSelectMol = function(mode)
{
  var selstr = this.getSelstrFromHitRes(mode);
  if (selstr==null)
    return;

  var res = this.mParent.getHittestRes();
  var obj = cuemol.getObject(res.obj_id);
  if (!obj)
    return;

  var scene = cuemol.getScene(this.mParent.mTgtSceneID);
  if (!scene) {
    dd("*** FATAL ERROR: Scene is null, cannot change props!! ***");
    return;
  }

  // EDIT TXN START //
  scene.startUndoTxn("Select atom(s)");

  try {
    var sel = cuemol.makeSel(selstr);
    if (sel===null) {
      throw "cannot compile selstr:"+selstr;
    }
    obj.sel = sel;
  }
  catch(e) {
    dd("SetProp error");
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //

  util.selHistory.append(selstr);
}

klass.vcmAddSelectMol = function(mode)
{
  var selstr = this.getSelstrFromHitRes(mode);
  if (selstr==null)
    return;

  var res = this.mParent.getHittestRes();
  var obj = cuemol.getObject(res.obj_id);
  if (!obj)
    return;

  var scene = cuemol.getScene(this.mParent.mTgtSceneID);
  if (!scene) {
    dd("*** FATAL ERROR: Scene is null, cannot change props!! ***");
    return;
  }

  var prevsel = obj.sel.toString();
  if (prevsel.length>0) {
    selstr = "("+prevsel+") or ("+selstr+")";
  }
  // dd("AddSel str="+selstr);

  // EDIT TXN START //
  scene.startUndoTxn("Add select atom(s)");

  try {
    var sel = cuemol.makeSel(selstr);
    if (sel===null) {
      throw "cannot compile selstr:"+selstr;
    }
    obj.sel = sel;
  }
  catch(e) {
    dd("SetProp error");
    debug.exception(e);
  }

  scene.commitUndoTxn();
  // EDIT TXN END //
}

klass.vcmUnSelectMol = function()
{
  var res = this.mParent.getHittestRes();
  var obj = cuemol.getObject(res.obj_id);
  if (!obj)
    return;

  var scene = cuemol.getScene(this.mParent.mTgtSceneID);
  if (!scene) {
    dd("*** FATAL ERROR: Scene is null, cannot change props!! ***");
    return;
  }

  // EDIT TXN START //
  scene.startUndoTxn("Unselect molecule");

  try {
    var sel = cuemol.createObj("SelCommand");
    obj.sel = sel;
  }
  catch(e) {
    dd("SetProp error");
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //
}

klass.vcmInvertMolSel = function()
{
  var res = this.mParent.getHittestRes();
  var obj = cuemol.getObject(res.obj_id);
  var scene = cuemol.getScene(this.mParent.mTgtSceneID);
  if (!('sel' in obj))
    return;
  var sel = obj.sel;
  sel = cuemol.makeInvSel(sel);

  // EDIT TXN START //
  scene.startUndoTxn("Invert mol selection");

  try {
      obj.sel = sel;
  }
  catch(e) {
    dd("NaviTool> SetProp error");
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //
}

klass.showAtomLabel = function(objid, atomid)
{
  const labeltype = "*namelabel";

  var obj = cuemol.getObject(objid);
  if (!obj) return;
  
  var scene = cuemol.getScene(this.mParent.mTgtSceneID);

  // EDIT TXN START //
  scene.startUndoTxn("Add atom label");

  try {
    var label_rend = obj.getRendererByType(labeltype);
    if (!label_rend) {
      // create new renderer
      label_rend = obj.createRenderer(labeltype);
      label_rend.applyStyles("DefaultLabel");
    }
    label_rend.addLabel(atomid);
  }
  catch(e) {
    dd("NaviTool> Add atom label: error");
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //
}


return ctor;

} )();

}

