// -*-Mode: C++;-*-
// $Id: fileopen.js,v 1.53 2011/03/13 12:02:45 rishitani Exp $
//

Qm2Main.prototype.makeFilter = function(fp, nCatID)
{
  var candidates = null;
  if (arguments.length==3)
    candidates = arguments[2];

  var info = JSON.parse(this.mStrMgr.getInfoJSON2());
  var names = [];
  
  for (var i=0; i<info.length; ++i) {
    var elem = info[i];
    if (elem.category!==nCatID)
      continue;

    if (candidates &&
        !candidates.some(function (e) {return e==elem.name;}))
      continue;

    if (fp)
      fp.appendFilter(elem.descr, elem.fext);
    dd("filter "+ elem.descr +"/"+ elem.fext);
    names.push(elem);
  }

  return names;
}

////////////////////////////////
// File open/save

Qm2Main.prototype.onFileOpen = function()
{
  const histry_name = "cuemol2.ui.histories.open_reader_name";
  const pref = require("preferences-service");
  var platform = util.getPlatformString();

  const nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

  var names;
  try {
    // 0 is category ID for obj reader
    names = this.makeFilter(fp, 0);
  }
  catch (e) {
    dd("Make filter is failed: "+e);
    debug.exception(e);
    return;
  }

  if (pref.has(histry_name)) {
    var prev_reader_name = pref.get(histry_name);
    names.forEach( function (elem, index) {
      if (elem.name==prev_reader_name)
        fp.filterIndex = index;
    });
  }

  fp.init(window, "Select a File", nsIFilePicker.modeOpen);

  var res = fp.show();
  if (res!=nsIFilePicker.returnOK) {
      return;
  }

  var newobj_name = fp.file.leafName;
  var findex = fp.filterIndex;
  var selected_reader_name = "";

  dump("leaf_name (newobj_name): "+newobj_name+"\n");

  if (platform === "Darwin") {
    // XXX: MaxOS version doesnt have filter dropdown,
    //      so always returns -1!!
    // TO DO: set findex based on the selected file name's extension
    findex = this.findMatchIOHandler(newobj_name, names);
    selected_reader_name = names[findex].name;
    dump("Warning: match findex="+findex+", default reader="+selected_reader_name+"\n");
  }
  else {
    selected_reader_name = names[findex].name;
    if (!selected_reader_name) {
      window.alert("FileOpen: invalid filter index "+findex+" in "+reader_names);
      return;
    }
  }

  var file_ext = names[findex].fext;
  var path = fp.file.path;
  dump("findex="+findex+"\n");
  dump("Reader="+selected_reader_name+"\n");

  // save filter index
  if (platform !== "Darwin") {
    //selected_reader_name = names[findex].name;
    pref.set(histry_name, selected_reader_name);
  }

  this.fileOpenHelper1(path, newobj_name, selected_reader_name);
}

Qm2Main.prototype.fileOpenHelper1 = function(path, newobj_name, reader_name)
{
  var scene = this.mMainWnd.currentSceneW;
  if (!scene) {
    window.alert("FileOpen: get current scene Failed.");
    return;
  }

  ///////////////////////////////
  // Make file reader obj (required for some option handlings)
  //
  var reader = this.mStrMgr.createHandler(reader_name, 0);
  reader.setPath(path);
  dd("Selected reader name: "+reader_name);

  var obj_type;
  var rend_types;
  ( function () {
    var tmpobj = reader.createDefaultObj();
    obj_type = tmpobj._wrapped.getClassName();
    rend_types = tmpobj.searchCompatibleRendererNames();
    delete tmpobj;
  }) ();

  //////////////////////////////
  // show the setup-rend dialog
  //
  var dlgdata = new Object();
  dlgdata.sceneID = scene.uid;
  dlgdata.ok = false;
  dlgdata.bEditObjName = true;
  dlgdata.target = new Array();
  dlgdata.target[0] = new Object();
  dlgdata.target[0].name = newobj_name;
  dlgdata.target[0].obj_type = obj_type;
  dlgdata.target[0].rend_types = rend_types;
  dlgdata.target[0].reader_name = reader_name;
  dlgdata.target[0].reader = reader;
  dlgdata.target[0].path = path;

  window.openDialog("chrome://cuemol2/content/fopen-option-dlg.xul",
                    "Setup renderer",
                    "chrome,modal,resizable=yes,dependent,centerscreen",
                    dlgdata);

  if (!dlgdata.ok) {
    dd("option dialog canceled");
    delete dlgdata;
    return;
  }
  
  //////////////////////
  // Do the actual tasks

  // EDIT TXN START //
  scene.startUndoTxn("Open file");
  try {
    var newobj = reader.createDefaultObj();
    reader.attach(newobj);
    reader.read();
    reader.detach();

    newobj.name = dlgdata.target[0].name;
    scene.addObject(newobj);

    dlgdata.obj_id = newobj.uid;
    this.doSetupRend(scene, dlgdata);
  }
  catch (e) {
    dd("File Open Error: "+e);
    debug.exception(e);
    
    this.mPrompts.alert(window, document.title,
                        "Failed to open file: "+path);
    reader = null;
    scene.rollbackUndoTxn();
    delete dlgdata;
    return;
  }

  reader = null;

  scene.commitUndoTxn();
  // EDIT TXN END //

  delete dlgdata;

}

Qm2Main.prototype.onFileSaveAs = function()
{
  var targetID;
  var targetObj;
  var that = this;
  
  targetID = this.doSelectObjPrompt("Select object to save", function (type, elem) {
    if (type!="object") return null;
    var rdrnames = that.mStrMgr.findCompatibleWriterNamesForObj(elem.ID);
    if (rdrnames.length==0)
      return null;
    return elem.name + " (" + elem.type + ", id="+elem.ID+")";
  });

  if (targetID===null)
    return;

  targetObj = cuemol.getObject(targetID);
  dd("target obj: "+targetObj);
  if (typeof targetObj=='undefined' || targetObj==null)
    return;

  var scene = this.mMainWnd.currentSceneW;
  if (!scene) {
    window.alert("FileSaveAs fatal error: get current scene Failed.");
    return;
  }

  const nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  fp.init(window, "Save Object As", nsIFilePicker.modeSave);

  var names;
  try {
    // 1 is category ID for obj writer
    var candidates = this.mStrMgr.findCompatibleWriterNamesForObj(targetObj.uid);
    candidates = candidates.split(",");
    dd("Write filter candidates: "+candidates);
    names = this.makeFilter(fp, 1, candidates);
  }
  catch (e) {
    dump("Make filter is failed: "+e+"\n");
    debug.exception(e);
    return;
  }

  // determine initial path and file name
  var obj_src;
  try {
    obj_src = targetObj.src;
    dd("object.src: "+obj_src);
    if (!obj_src) {
      fp.defaultString = targetObj.name;
      fp.defaultExtension = names[0].fext;
    }
    else {
      var init_file = Cc["@mozilla.org/file/local;1"].createInstance(Ci.nsILocalFile);
      init_file.initWithPath(obj_src);
      fp.defaultString = "copy_of_"+init_file.leafName;
      fp.displayDirectory = init_file.parent;
    }
  }
  catch (e) {
    debug.exception(e);
    dd("Cannot determine default file name, src="+obj_src);
  }
  
  var res=fp.show();
  if (res==nsIFilePicker.returnCancel)
    return;

  var writer_name = names[fp.filterIndex].name;
  var path = fp.file.path;
  dd("Selected writer name: "+writer_name);
  dd("path: "+path);
  var writer = this.mStrMgr.createHandler(writer_name, 1);
  writer.setPath(path);
  dd("Created writer: "+writer._wrapped.getClassName());

  try {
    writer.attach(targetObj);
    writer.write();
    writer.detach();
  }
  catch (e) {
    dd("File Save Error: "+e);
    debug.exception(e);
    
    this.mPrompts.alert(window, document.title,
                        "Failed to save file: "+path);
  }

  delete writer;
  delete targetObj;
}

///////////////////////////////////////////////////////
// Scene file I/O

Qm2Main.prototype.readSceneFile = function(sc, path, reader_name)
{
  var reader = this.mStrMgr.createHandler(reader_name, 3);

  dump("read scene: "+path+"\n");
  // dump("write inc: "+incfile+"\n");

  reader.attach(sc);
  reader.setPath(path);
  reader.read();
  reader.detach();
  // reader is expected to be removed by GC...
  reader = null;

  dd("********** READ_SCENE_FILE OK: "+path);

  dd("********** SET_SCENE_NAME: "+path);
  var newname = require("util").getFileLeafName(path);
  dd("********** SET_SCENE_NAME: "+newname);
  sc.setName(newname);
}

Qm2Main.prototype.createAndReadSceneFile = function(path, reader_name)
{
  var sc = cuemol.sceMgr.createScene();
  if (!sc) {
    // window.alert("SceneOpen: create scene failed.");
    return null;
  }
  var scid = sc.uid;
      
  // Load scene
  this.readSceneFile(sc, path, "qsc_xml");
      
  var vw = sc.createView();
  var vwid = vw.uid;
  vw.name = "Primary view";
      
  // load view setting
  if (!sc.loadViewFromCam(vwid, "__current")) {
    dd("OnOpenScene> loadViewFromCam FAILED!!\n");
    // ignore error
  }

  return [scid, vwid];
}

Qm2Main.prototype.writeSceneFile = function(sc, path, writer_name)
{
  try {
    var writer = this.mStrMgr.createHandler(writer_name, 4);

    dd("Write scene to: "+path);
    // dump("write inc: "+incfile+"\n");

    writer.attach(sc);
    writer.setPath(path);
    writer.write();
    writer.detach();
    // writer is expected to be removed by GC...
    writer = null;
  }
  catch (e) {
    dd("write scene failed: "+e);
    debug.exception(e);
    window.alert("write scene failed.");
    return false;
  }

  // writing scene results in discarding undo/redo data
  sc.clearUndoData();

  return true;
}

Qm2Main.prototype.onOpenScene = function()
{
  const nsIFilePicker = Ci.nsIFilePicker;
  var fp = Cc["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

  try {
    // 3 is category ID for scene reader
    var names = this.makeFilter(fp, 3);
  }
  catch (e) {
    dump("Make filter is failed: "+e+"\n");
    return;
  }

  fp.init(window, "Open Scene", nsIFilePicker.modeOpen);

  var res=fp.show();
  if (res!=nsIFilePicker.returnOK) {
      return;
  }

  this.openSceneImpl(fp.file.path, names[fp.filterIndex].name);
}

Qm2Main.prototype.openSceneImpl = function(path, scene_type)
{
  var scene = this.mMainWnd.currentSceneW;
  
  if (scene && scene.isJustCreated()) {
    // scene is just created and empty, so we read into it without adding new tab
    try {
      this.readSceneFile(scene, path, scene_type);
    }
    catch (e) {
      debug.exception(e);
      util.alert(window, "Read scene from \""+path+"\" was failed.\nReason: "+cuemol.getErrMsg());
      scene.clearAllData();
      return;
    }
    var view = this.mMainWnd.currentViewW;
    if (view)
      scene.loadViewFromCam(view.uid, "__current");
    return;
  }
  else {
    var result;
    try {
      result = this.createAndReadSceneFile(path, scene_type);
    }
    catch (e) {
      debug.exception(e);
      util.alert(window, "Read scene from \""+path+"\" was failed.\nReason: "+cuemol.getErrMsg());
      scene.clearAllData();
      return;
    }

    this.mMainWnd.addMolViewTab(result[0], result[1]);
  }
}

Qm2Main.prototype.onReloadScene = function()
{
  var sc = this.mMainWnd.currentSceneW;
  if (!sc) {
    window.alert("Reload scene: get current scene failed.");
    return;
  }

  var path = sc.src;
  var rdrnm = sc.srctype;
  if (!path || !rdrnm || !require("util").isFileExist(path)) {
    dd("Reload of unsaved scene is requested (ignored).");
    return;
  }

  if (sc.modified) {
    var scene_name = sc.name;
    if (!scene_name) scene_name = "";
    var result = this.mPrompts.confirm(window, document.title,
                                       "Do you want to reload the scene :"+scene_name+" ?");
    if (!result) return;
  }

  sc.clearAllData();

  try {
    this.readSceneFile(sc, path, rdrnm);
  }
  catch (e) {
    util.alert("Read scene failed: "+e);
    sc.clearAllData();
    return;
  }

  // load view setting
  var vwid = this.mMainWnd.getCurrentViewID();
  sc.loadViewFromCam(vwid, "__current");
}

Qm2Main.prototype.onSaveSceneAs = function ()
{
  var vwid = this.mMainWnd.getCurrentViewID();
  var sc = this.mMainWnd.currentSceneW;
  if (!sc) {
    window.alert("Save: get current scene Failed.");
    return false;
  }

  const nsIFilePicker = Ci.nsIFilePicker;
  var fp = Cc["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

  try {
    // 4 is category ID for scene writer
    var names = this.makeFilter(fp, 4);
  }
  catch (e) {
    dump("Make filter is failed: "+e+"\n");
    return false;
  }

  // set default name as the scene name (and the first file type)
  fp.defaultString = sc.name;
  fp.defaultExtension = names[0].fext;

  fp.init(window, "Save Scene As", nsIFilePicker.modeSave);

  var res=fp.show();
  if (res==nsIFilePicker.returnCancel) {
    //window.alert("Save: canceled.");
    return false;
  }

  var writer_name = names[fp.filterIndex].name;
  if (fp.filterIndex<0)
    writer_name = names[0].name;

  // This modifies file name if there is no extension
  var path = fp.file.path;
  var res = util.splitFileName2(path, names[fp.filterIndex].fext);
  if (res) {
    path = res.path;
  }

  // save the current view setting
  if (!sc.saveViewToCam(vwid, "__current")) {
    dump("****** saveViewToCam FAILED!!\n");
  }

  this.writeSceneFile(sc, path, writer_name);
  sc.setName(require("util").getFileLeafName(path));
  return true;
}

Qm2Main.prototype.onSaveScene = function ()
{
  var sc = this.mMainWnd.currentSceneW;
  if (!sc) {
    require("util").alert(window, "Save: get current scene Failed.");
    return false;
  }

  var path = sc.src;
  var rdrnm = sc.srctype;

  if (!path || !require("util").isFileExist(path))
    return this.onSaveSceneAs();

  var vw = this.mMainWnd.currentViewW;
  if (vw) {
    if (!sc.saveViewToCam(vw.uid, "__current")) {
      dump("****** saveViewToCam FAILED!!\n");
    }
  }
  this.writeSceneFile(sc, path, rdrnm);
  return true;
}

////////////////////////////////////////////////////
// Camera/View file I/O

Qm2Main.prototype.onSaveCurView = function ()
{
  var scene = this.mMainWnd.currentSceneW;
  if (!scene) {
    window.alert("Save: get current scene Failed.");
    return;
  }

  var vwid = this.mMainWnd.getCurrentViewID();
  
  if (!scene.saveViewToCam(vwid, "__current")) {
    window.alert("Save camera failed!");
    return;
  }

  this.onSaveCamera("__current");
}

Qm2Main.prototype.onSaveCamera = function (aName)
{
  var scene = this.mMainWnd.currentSceneW;
  if (!scene) {
    window.alert("Save: get current scene Failed.");
    return;
  }

  const nsIFilePicker = Ci.nsIFilePicker;
  var fp = Cc["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  fp.appendFilter("Camera setting (*.cam)", "*.cam");

  fp.init(window, "Select a File", nsIFilePicker.modeSave);

  var res=fp.show();
  if (res==nsIFilePicker.returnCancel)
    return;

  var path = fp.file.path;
  var res = util.splitFileName2(path, "*.cam");
  if (res) {
    path = res.path;
  }

  // save the current view setting
  if (!scene.saveCameraTo(path, aName)) {
    window.alert("Save camera failed!");
    return;
  }
}

Qm2Main.prototype.onExecJSTest = function ()
{
  var scene = this.mMainWnd.currentSceneW;
  if (!scene) {
    window.alert("Save: get current scene Failed.");
    return;
  }

  const nsIFilePicker = Ci.nsIFilePicker;
  var fp = Cc["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  fp.appendFilter("Javascript (*.js)", "*.js");
  // fp.appendFilter("HTML (*.html)", "*.html");

  fp.init(window, "Select a File", nsIFilePicker.modeOpen);

  var res=fp.show();
  if (res==nsIFilePicker.returnCancel)
    return;

  scene.execJSFile(fp.file.path);
  // var path = fp.file.path;
  // var url = fp.fileURL;
  // window.open(url.spec, "_blank",
  // "chrome,extrachrome,menubar,resizable,scrollbars,status,toolbar");
}

///////////////////////////////////////////////////////
// Rendering file export

Qm2Main.prototype.exportScene = function()
{
  const nsIFilePicker = Ci.nsIFilePicker;
  var fp = Cc["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

  try {
    // 2 is category ID for scene exporters
    var names = this.makeFilter(fp, 2);
  }
  catch (e) {
    dd("Make filter is failed");
    debug.exception(e);
    return;
  }

  fp.init(window, "Select a File", nsIFilePicker.modeSave);

  var res=fp.show();
  if (res==nsIFilePicker.returnCancel) {
    //window.alert("Save: canceled.");
    return;
  }

  var fext = names[fp.filterIndex].fext;

  var path = fp.file.path;
  var extpos = util.splitFileName(path, fext);
  if (extpos<0) {
    // no extension str
    var extpos2 = fext.lastIndexOf(".");
    path = path + fext.substr(extpos2);
    extpos = util.splitFileName(path, fext);
  }
  // this is POV specific
  var incfile = path.substr(0, extpos) + ".inc";

  var exporter = this.mStrMgr.createHandler(names[fp.filterIndex].name,
                                            names[fp.filterIndex].category);
  if (typeof exporter==="undefined" || exporter===null) {
    window.alert("Save: get exporter Failed.");
    return;
  }

  var view = this.mMainWnd.currentViewW;
  var sc = this.mMainWnd.currentSceneW;
  if (typeof sc==="undefined" || sc===null) {
    window.alert("Save: get current scene Failed.");
    return;
  }

  // save the current view setting
  if (!sc.saveViewToCam(view.uid, "__current")) {
    dd("****** saveViewToCam FAILED!!");
  }

  // Do filetype specific actions
  if (exporter.name == "png") {
    // show PNG option dialog
    var dlgdata = new Object();
    dlgdata.exporter = exporter;
    dlgdata.path = path;
    dlgdata.ok = false;
    dlgdata.width = view.width;
    dlgdata.height = view.height;

    window.openDialog("chrome://cuemol2/content/exportpng-opt-dlg.xul",
                      "PNG options",
                      "chrome,modal,resizable=yes,dependent,centerscreen",
                      dlgdata);

    if (!dlgdata.ok) {
      dd("option dialog canceled");
      delete dlgdata;
      delete exporter;
      return;
    }

  }

  try {
    dd("write: "+path);
    dd("write inc: "+incfile);

    // use camera of the current view (TO DO: configurable)
    exporter.camera = "__current";

    exporter.attach(sc);
    exporter.setPath(path);
    exporter.setSubPath("inc", incfile);
    exporter.write();
    exporter.detach();
  }
  catch (e) {
  }

  // exporter is expected to be removed by GC...
  exporter = null;
}

///////////////////////////////////////////////////////
// Drag and drop operations

/// find matching io handler (names) for the file name (filename) and returns the index
Qm2Main.prototype.findMatchIOHandler = function(filename, names)
{
  // TO DO: check the content of the file is actually readable

  for (var i=0; i<names.length; ++i) {
    var ext = names[i].fext;
    var c = util.splitFileName(filename, ext);
    if (c>=0) {
      // matching handler is found
      return i;
    }
  }

  return -1;
}

Qm2Main.prototype.onDragOver = function (aEvent)
{
  //dd("DragOverCalled: "+aEvent.dataTransfer.types);

  //for (var i=0; i<aEvent.dataTransfer.types.length; ++i) {
  //dd("  type "+aEvent.dataTransfer.types[i]);
  //}

  var isFileDrag = aEvent.dataTransfer.types.contains("application/x-moz-file");
  if (isFileDrag) {
    aEvent.preventDefault();
    aEvent.stopPropagation();
  }
}

Qm2Main.prototype.onDragLeave = function (aEvent)
{
  //dd("DragLeaveCalled: "+aEvent.dataTransfer.types);
}

Qm2Main.prototype.onDrop = function (aEvent)
{
  dd("Drop Called: "+aEvent.dataTransfer.types);

  //for (var i=0; i<event.dataTransfer.types.length; ++i) {
  //dd("  type "+event.dataTransfer.types[i]);
  //}
  var isDrag = aEvent.dataTransfer.types.contains("application/x-moz-file");
  if (!isDrag)
    return;

  //dd("JSON: "+JSON.stringify(aEvent.dataTransfer));
  var data = aEvent.dataTransfer.getData("application/x-moz-file");
  dd("drag data application/x-moz-file: "+data);
  data = aEvent.dataTransfer.getData("Files");
  dd("drag data Files: "+data);
  data = aEvent.dataTransfer.getData("text/x-moz-url");
  dd("drag data url: "+data);
  
  var dt = aEvent.dataTransfer;
  dd("mozItemCount: "+ dt.mozItemCount);

  var names;
  try {
    // 0 is category ID for obj reader
    names = this.makeFilter(null, 0);
  }
  catch (e) {
    dd("Make filter is failed: "+e);
    debug.exception(e);
    return;
  }

  // append scene file (qsc) entry
  var sc_names;
  try {
    // 3 is category ID for scene reader
    sc_names = this.makeFilter(null, 3);
  }
  catch (e) {
    dump("Make filter is failed: "+e+"\n");
    return;
  }

  var findex;

  for (var i = 0; i < dt.mozItemCount; i++) {
    var moz_data = dt.mozGetDataAt("application/x-moz-file", i);
    dd("mozGetData: "+ i + ", data="+moz_data);
    if (moz_data instanceof Ci.nsIFile) {
        dd("  nsIFile: "+ moz_data.path);
      
      var newobj_name = moz_data.leafName;
      dd("  leafName: "+ newobj_name);
      
      // check Object readers
      findex = this.findMatchIOHandler(newobj_name, names);
      if (findex>=0) {
        var reader_name = names[findex].name;
        dd("  suggested reader name: "+ reader_name);
        this.fileOpenHelper1(moz_data.path, newobj_name, reader_name);
        continue;
      }

      // check Scene readers
      findex = this.findMatchIOHandler(newobj_name, sc_names);
      if (findex>=0) {
        var reader_name = sc_names[findex].name;
        dd("  suggested reader name: "+ reader_name);
        this.openSceneImpl(moz_data.path, reader_name);
        continue;
      }

    }
  }
}


