//
//
// $Id: fakedial-panel.js,v 1.1 2011/02/19 14:44:13 rishitani Exp $

if (!("fakedial" in cuemolui.panels)) {

( function () {

var panel = cuemolui.panels.fakedial = new Object();

// panel's ID
panel.id = "fakedial-panel";

panel.collapsed = true;
panel.command_id = "menu-fakedial-panel-toggle";

window.addEventListener("load", function(){panel.onLoad();}, false);

panel.onLoad = function ()
{
  this._mainWnd = document.getElementById("main_view");

  this.mRotXList = document.getElementById("fdl-rotx-list");
  this.mRotYList = document.getElementById("fdl-roty-list");
  this.mRotZList = document.getElementById("fdl-rotz-list");

  this.mTraXList = document.getElementById("fdl-trax-list");
  this.mTraYList = document.getElementById("fdl-tray-list");
  this.mTraZList = document.getElementById("fdl-traz-list");

  this.mZoomList = document.getElementById("fdl-zoom-list");
  this.mSlabList = document.getElementById("fdl-slab-list");

  this.mTraXVal = document.getElementById("fdl-trax-val");
  this.mTraYVal = document.getElementById("fdl-tray-val");
  this.mTraZVal = document.getElementById("fdl-traz-val");

  this.mZoomVal = document.getElementById("fdl-zoom-val");
  this.mSlabVal = document.getElementById("fdl-slab-val");

  this.updateTransVal();
  this.updateZsVal();
}

panel.onRotBtnCmd = function (aEvent)
{
  var id = aEvent.target.id;
  dd("RotBtnCmd: "+id);
  var del;

  switch (id) {
  case "fdl-rotx-lb":
    del = parseFloat(this.mRotXList.value);
    this._mainWnd.rotateView(del, 0, 0);
    break;

  case "fdl-rotx-rb":
    del = parseFloat(this.mRotXList.value);
    this._mainWnd.rotateView(-del, 0, 0);
    break;

  case "fdl-roty-lb":
    del = parseFloat(this.mRotYList.value);
    this._mainWnd.rotateView(0, del, 0);
    break;

  case "fdl-roty-rb":
    del = parseFloat(this.mRotYList.value);
    this._mainWnd.rotateView(0, -del, 0);
    break;

  case "fdl-rotz-lb":
    del = parseFloat(this.mRotZList.value);
    this._mainWnd.rotateView(0, 0, del);
    break;

  case "fdl-rotz-rb":
    del = parseFloat(this.mRotZList.value);
    this._mainWnd.rotateView(0, 0, -del);
    break;
  }
}

panel.onTraBtnCmd = function (aEvent)
{
  var id = aEvent.target.id;
  dd("TraBtnCmd: "+id);
  var del;

  switch (id) {
  case "fdl-trax-lb":
    del = parseFloat(this.mTraXList.value);
    this._mainWnd.translateView(-del, 0, 0);
    break;

  case "fdl-trax-rb":
    del = parseFloat(this.mTraXList.value);
    this._mainWnd.translateView(del, 0, 0);
    break;

  case "fdl-tray-lb":
    del = parseFloat(this.mTraYList.value);
    this._mainWnd.translateView(0, del, 0);
    break;

  case "fdl-tray-rb":
    del = parseFloat(this.mTraYList.value);
    this._mainWnd.translateView(0, -del, 0);
    break;

  case "fdl-traz-lb":
    del = parseFloat(this.mTraZList.value);
    this._mainWnd.translateView(0, 0, del);
    break;

  case "fdl-traz-rb":
    del = parseFloat(this.mTraZList.value);
    this._mainWnd.translateView(0, 0, -del);
    break;

  default:
    return;
  }

  this.updateTransVal();
}

panel.updateTransVal = function ()
{
  var vec = this._mainWnd.getViewCenter();
  var val = vec.x;
  this.mTraXVal.value = val.toFixed(2);
  var val = vec.y;
  this.mTraYVal.value = val.toFixed(2);
  var val = vec.z;
  this.mTraZVal.value = val.toFixed(2);
}

panel.onZsBtnCmd = function (aEvent)
{
  var id = aEvent.target.id;
  dd("ZsBtnCmd: "+id);
  var del, val;

  switch (id) {
  case "fdl-zoom-lb":
    del = parseFloat(this.mZoomList.value);
    val = this._mainWnd.zoomView(-del);
    this.mZoomVal.value = val.toFixed(2);
    break;

  case "fdl-zoom-rb":
    del = parseFloat(this.mZoomList.value);
    val = this._mainWnd.zoomView(del);
    this.mZoomVal.value = val.toFixed(2);
    break;

  case "fdl-slab-lb":
    del = parseFloat(this.mSlabList.value);
    val = this._mainWnd.slabView(-del);
    this.mSlabVal.value = val.toFixed(2);
    break;

  case "fdl-slab-rb":
    del = parseFloat(this.mSlabList.value);
    val = this._mainWnd.slabView(del);
    this.mSlabVal.value = val.toFixed(2);
    break;

  }
}

panel.updateZsVal = function ()
{
  var val = 0.0;
  this.mZoomVal.value = val.toFixed(2);
  this.mSlabVal.value = val.toFixed(2);
}

} )();

}

