// -*-Mode: C++;-*-
//
// $Id: cuemol2-utils.js,v 1.19 2011/05/01 09:28:03 rishitani Exp $
//

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;
const Cr = Components.results;

Cu.import("resource://app/resources/jpk_hns.js");

var cuemol = new Object();
cuemol.xpc = Cc["@cuemol.org/XPCCueMol"].getService(Ci.qICueMol);

cuemol.utils = new Object();

cuemol.utils.convPolymObj = function convPolymObj(aWrapped)
{
  if (typeof(aWrapped) === 'undefined') return null;

  var clsnm, wrclsnm, filenm;
  try {
    clsnm = aWrapped.getClassName();
    wrclsnm = "wrapper_"+clsnm;
    filenm = "resource://app/resources/cuemol-wrappers/"+clsnm+".js";
  }
  catch(e) {
    dump("argument of convPolymObj("+aWrapped+") is not a XPCCueMol object: "+e+"\n");
    return null;
  }

  // dd("cuemol.utils.convPolymObj> Calling wrapper's ctor for "+wrclsnm);

  try {

    if (wrclsnm in cuemol) {
      var ctor = cuemol[wrclsnm];
    }
    else {
      // wrapper class is not loaded
      dump("loading: "+filenm+"\n");
      Cu.import(filenm, cuemol);
      var ctor = cuemol[wrclsnm];
    }
    
    var obj = new ctor (aWrapped, cuemol);
    return obj;

  }
  catch(e) {
    dump("Cannot call ctor for "+clsnm+": "+e+"\n");
    return null;
  }

}

cuemol.getErrMsg = function ()
{
  return cuemol.xpc.getErrMsg();
}

cuemol.getService = function (name)
{
  if (!cuemol.xpc.isInitialized())
    return null;
  var obj = cuemol.xpc.getService(name);
  return cuemol.utils.convPolymObj(obj);
}

cuemol.createObj = function (name)
{
  if (!cuemol.xpc.isInitialized())
    return null;
  var obj = cuemol.xpc.createObj(name);
  return cuemol.utils.convPolymObj(obj);
}

cuemol._sceMgr=null;

cuemol.__defineGetter__("sceMgr", function() {
  if (!cuemol.xpc.isInitialized())
    return null;
  if (this._sceMgr==null)
    this._sceMgr = cuemol.getService("SceneManager");
  return this._sceMgr;
});

cuemol.getObject = function (aObjID)
{
  return this.sceMgr.getObject(aObjID);
}

cuemol.getScene = function (aID)
{
  return this.sceMgr.getScene(aID);
}

cuemol.getRenderer = function (aID)
{
  return this.sceMgr.getRenderer(aID);
}

cuemol.getView = function (aID)
{
  return this.sceMgr.getView(aID);
}

var cuemolui = new Object();

const debug = require("debug_util");
const dd = debug.dd;
const util = require("util");


////////////////////////////////

cuemol.makeSel = function(selstr, uid)
{
  var sel = cuemol.createObj("SelCommand");
  if (uid) {
    if (!sel.compile(selstr, uid))
      return null;
  }
  else {
    if (!sel.compile(selstr, 0))
      return null;
  }
  return sel;
};

cuemol.makeColor = function(str, uid)
{
  var stylem = cuemol.getService("StyleManager");
  var color = null;
  if (uid) {
    color = stylem.compileColor(str, uid);
  }
  else {
    color = stylem.compileColor(str, 0);
  }

  return color;
};

cuemol.makeInvSel = function(sel)
{
  var selstr = sel.toString();
  var invsel;
  if (selstr=="") {
    invsel = "*";
  }
  else {
    var res = selstr.match(/!\s*\((.+)\)/);
    if (res==null)
      invsel = "!("+selstr+")";
    else 
      invsel = res[1];
  }
  dd("MakeInvSel invsel="+invsel);
  return cuemol.makeSel(invsel);
}

 /*
function extendClass(subclass, superclass)
{
  var f = function() {};
  f.prototype = superclass.prototype;
  subclass.prototype = new f();
  subclass.prototype.constructor = subclass;
  subclass.superclass = superclass.prototype;
  if (superclass.prototype.constructor == Object.prototype.constructor) {
    superclass.prototype.constructor = superclass;
  }
};
function extendClass(s, c)
{
  function f(){};
  f.prototype = s.prototype;
  c.prototype = new f();
  c.prototype.__super__ = s.prototype;
  c.prototype.__super__.constructor = s;
  c.prototype.constructor = c;
  return c;
};
*/

cuemol.resetProp = function (obj, propname)
{
  obj._wrapped.resetProp(propname);
};

cuemol.hasProp = function (obj, propname)
{
  return obj._wrapped.hasProp(propname);
};

cuemol.onPaintColShowing = function (aEvent)
{
  try {
    var scene_id = gQm2Main.mMainWnd.getCurrentSceneID();
    var menu = aEvent.currentTarget.menupopup;
    cuemol.populateStyleMenus(scene_id, menu, /Paint$/);
  } catch (e) { debug.exception(e); }
};

cuemol.populateStyleMenus = function (scene_id, menu, regexp)
{
  if (regexp==null) {
    util.clearMenu(menu);
    var item = util.appendMenu(document, menu, "", "(no styles)");
    //item.disabled = true;
    item.setAttribute("disabled", "true");
    return;
  }

  var stylem = cuemol.getService("StyleManager");
  var json = stylem.getStyleNamesJSON(0);
  //dd("JSON: "+json);
  var names = JSON.parse(json);

  json = stylem.getStyleNamesJSON(scene_id);
  //dd("JSON: "+json);
  names = names.concat( JSON.parse(json) );

  //dd("MenuElem: "+menu.localName);
  var nitems = names.length;
  var name, value, label, res;
  util.clearMenu(menu);
  for (var i=0; i<nitems; ++i) {
    name = names[i].name;
    res = name.match(regexp);
    if (res==null) {
      //dd("Style "+name+" no match: "+regexp);
      continue;
    }
    //dd("PaintColAddMenu = "+name);
    value = "style-"+name;
    label = names[i].desc;
    if (!label)
      label = name;
    var item = util.appendMenu(document, menu, value, label);
    item.setAttribute("remove_re", regexp);
  }
};

