//
// XPCOM native window Win32 implementation class
//
// $Id: XPCNativeWidgetWin.hpp,v 1.3 2010/12/23 14:34:19 rishitani Exp $
//

#ifndef XPC_NATIVE_WIDGET_WIN_HPP
#define XPC_NATIVE_WIDGET_WIN_HPP

#include "XPCNativeWidget.hpp"
#include <qsys/sysdep/MouseEventHandler.hpp>

#include <windowsx.h>
#include <gl/gl.h>
#include <gl/glu.h>

namespace sysdep { class WglView; }
namespace qsys { class InDevEvent; }

namespace xpcom {

  class XPCNativeWidgetWin : public XPCNativeWidget
  {
  public:
    XPCNativeWidgetWin();
    virtual ~XPCNativeWidgetWin();

  public:
    virtual nsresult setupImpl(nsIWidget *widget);
    virtual nsresult attachImpl();
    virtual void unloadImpl();
    virtual void resizeImpl(int x, int y, int width, int height);

    /// Win32 event handler impl
    LRESULT handleEvent(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

    NS_SCRIPTABLE NS_IMETHOD Reload(PRBool *_retval NS_OUTPARAM);

  private:
    /// parent GDK window object
    HWND m_hParWnd;

    /// child GDK window object
    HWND m_hWnd;

    /// DC for child window
    HDC m_hDC;

    // /// GL rendering context
    // HGLRC m_hGL;

    HWND selectParentWindow(HWND hWnd);

    sysdep::WglView *m_pWglView;

    qsys::MouseEventHandler m_meh;

    //bool setupOpenGL();
    //bool setupOpenGL2();
    //void cleanupOpenGL();

    bool m_bCursorIn;

    void setUpMouseEvent(UINT msg, WPARAM wParam, LPARAM lParam, qsys::InDevEvent &ev);
    
    HWND createNativeChildWnd();

  };

}

#endif
