//
// XPCOM native window Win32 implementation
//
// $Id: XPCNativeWidgetWin.cpp,v 1.11 2011/02/20 09:34:26 rishitani Exp $
//

#include <common.h>

#include "XPCNativeWidgetWin.hpp"

#include "xpcom.hpp"

#include <qsys/InDevEvent.hpp>
#include <qsys/sysdep/WglView.hpp>
#include <qsys/sysdep/WglDisplayContext.hpp>

using namespace xpcom;
using gfx::DisplayContext;
using sysdep::WglDisplayContext;

XPCNativeWidgetWin::XPCNativeWidgetWin()
{
  MB_DPRINTLN("!! XPCNativeWidgetWin ctor called.");
  m_hParWnd = NULL;
  m_hWnd = NULL;
  // mGC = nsnull;
  m_hDC = NULL; 
  m_bCursorIn = false;
}

XPCNativeWidgetWin::~XPCNativeWidgetWin()
{
  MB_DPRINTLN("!! XPCNativeWidgetWin dtor called.");
}

// entry stub
static
LRESULT CALLBACK sHandleWin32Event(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  // get our plugin instance object and ask it for the version string
  LONG ldata = GetWindowLong(hWnd, GWL_USERDATA);
  XPCNativeWidgetWin *ppn = reinterpret_cast<XPCNativeWidgetWin *>(ldata);

  if (ppn)
    return ppn->handleEvent(hWnd, msg, wParam, lParam);

  return ::DefWindowProc(hWnd, msg, wParam, lParam);
}

HWND XPCNativeWidgetWin::createNativeChildWnd()
{
  WNDCLASSEX wc;
  wc.cbSize = sizeof wc;
  wc.style         = CS_HREDRAW|CS_VREDRAW; //CS_DBLCLKS;
  wc.lpfnWndProc   = sHandleWin32Event;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = NULL;
  wc.hIcon         = NULL; //::LoadIcon(::GetModuleHandle(NULL), IDI_APPLICATION);
  wc.hCursor       = NULL;
  wc.hbrBackground = (HBRUSH)::GetStockObject(NULL_BRUSH);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = L"CueMol2NativeWidget";
  wc.hIconSm = NULL;

  if (::RegisterClassEx(&wc)==0) {
    DWORD nerr = GetLastError();
    if (nerr!=ERROR_CLASS_ALREADY_EXISTS) {
      LOG_DPRINTLN("XPCNativeWidgetWin> FATAL ERROR, Cannot register window class!!");
      return NULL;
    }
  }

  MB_DPRINTLN("XPCNativeWidgetWin> Register window class: OK");

  int width = getWidth(), height=getHeight();
  if (width<0) width = 100;
  if (height<0) height = 100;

  HWND wnd = CreateWindow(wc.lpszClassName,
                          L"native view",
                          WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,
                          0, 0, width, height,
                          m_hParWnd,
                          NULL,
                          NULL,
                          NULL);
  return wnd;
}

nsresult XPCNativeWidgetWin::setupImpl(nsIWidget *widget)
{
  HWND hwnd = (HWND)widget->GetNativeData(NS_NATIVE_WINDOW);
  if (!hwnd) {
    return NS_ERROR_INVALID_POINTER;
  }

  hwnd = selectParentWindow(hwnd);
  MB_DPRINT("native win: %p\n", hwnd);
  m_hParWnd = hwnd;

  HWND wnd = createNativeChildWnd();

  if (!wnd) {
    LOG_DPRINTLN("XPCNativeWidgetWin> FATAL ERROR, Cannot create window!!");
    return NS_ERROR_INVALID_POINTER;
  }

  m_hWnd = wnd;

  // associate window with our nsPluginInstance object so we can access
  // it in the window procedure
  SetWindowLong(m_hWnd, GWL_USERDATA, (LONG)this);

  ::ShowWindow( m_hWnd, SW_SHOW );
  ::UpdateWindow( m_hWnd );

  return NS_OK;
}

nsresult XPCNativeWidgetWin::attachImpl()
{
  if (!m_hWnd) {
    MB_DPRINT("XPCNativeWidgetWin::attachImpl mView is not initialized!!\n");
    return NS_ERROR_FAILURE;
  }

  // get the device context (DC)
  m_hDC = ::GetDC( m_hWnd );
  if (!m_hDC) {
    MB_DPRINT("XPCNativeWidgetWin::attachImpl cannot create device context!!\n");
    return NS_ERROR_FAILURE;
  }
  
  qsys::View *ptmp = getQmView().get();
  NS_ENSURE_TRUE(ptmp, NS_ERROR_FAILURE);
  
  MB_DPRINT("Win bind: view %p type=%s\n", ptmp, typeid(*ptmp).name());

  sysdep::WglView *pWglView = dynamic_cast<sysdep::WglView *>(ptmp);
  if (pWglView==NULL) {
    m_pWglView = NULL;
    LOG_DPRINTLN("WIN32 bind failed: invalid view %p !!", ptmp);
    return NS_ERROR_FAILURE;
  }
  
  // set cached view ptr
  m_pWglView = pWglView;

  bool res = pWglView->attach(m_hWnd, m_hDC);
  MB_DPRINTLN("Win bind: %s", res?"OK":"NG");
  if (!res) {
    m_pWglView = NULL;
    return NS_ERROR_FAILURE;
  }

  m_pWglView->sizeChanged(getWidth(), getHeight());

  MB_DPRINT("XPCNativeWidgetWin::attachImpl OK\n");
  return NS_OK;
}

void XPCNativeWidgetWin::unloadImpl()
{
  // cleanupOpenGL();

  if (m_hWnd) {
    ::ShowWindow( m_hWnd, SW_HIDE );
    ::SetParent( m_hWnd, NULL );
    ::DestroyWindow(m_hWnd);
    m_hWnd = NULL;
  }

  m_hParWnd = NULL;

}

void XPCNativeWidgetWin::resizeImpl(int x, int y, int w, int h)
{
  if (!m_hWnd) return;

  setSize(w, h);

  //BOOL res = ::MoveWindow(m_hWnd, 0, 0, w, h, 1);
  BOOL res = ::SetWindowPos(m_hWnd, HWND_TOP, 0, 0, w, h, 0);
  RECT rc;
  rc.left = 0;
  rc.right = w;
  rc.top = 0;
  rc.bottom = h;
  ::InvalidateRect(m_hWnd, &rc, FALSE);

  m_pWglView->sizeChanged(w, h);
  // redrawImpl(0, 0, width, height);
}

HWND XPCNativeWidgetWin::selectParentWindow(HWND hWnd)
{
  // Select Parent Window attempts to select the best parent for the video
  // window so that all events get propagated through the various WindowProcs
  // as expected.

  HWND retWnd = NULL;
  HWND firstChildWnd = ::GetWindow(hWnd, GW_CHILD);

  if(firstChildWnd != NULL) {
    retWnd = ::GetWindow(firstChildWnd, GW_HWNDLAST);
  }

  if(!retWnd) {
    retWnd = hWnd;
  }

  return retWnd;
}

LRESULT
XPCNativeWidgetWin::handleEvent(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  switch (msg) {
  case WM_PAINT: {
    // draw a frame and display the string
    PAINTSTRUCT ps;
    HDC hdc = BeginPaint(hWnd, &ps);
    m_pWglView->forceRedraw();
    EndPaint(hWnd, &ps);
    return 0;
    //break;
  }

    // WM_SIZE will be handled in DOM event listener
  /*case WM_SIZE: {
    int cx = LOWORD(lParam);
    int cy = HIWORD(lParam);
    sizeChanged(cx, cy);
    return 0;
    //break;
  }*/

  case WM_LBUTTONDOWN: 
  case WM_RBUTTONDOWN: {
    //MB_DPRINTLN("****** WM_MOUSE LR DOWN");
    qsys::InDevEvent ev;
    setUpMouseEvent(msg, wParam, lParam, ev);
    dispatchMouseEvent(0, ev);
    ::SetCapture(hWnd);

    return 0;
    //break;
  }

  case WM_MOUSEMOVE: {

    /*if (!m_bCursorIn) {
      //MB_DPRINTLN("****** Mouse Enter ??? ");
      TRACKMOUSEEVENT tme;
      tme.cbSize = sizeof tme;
      tme.dwFlags = TME_LEAVE;
      tme.hwndTrack = m_hWnd;
      ::TrackMouseEvent(&tme);
      m_bCursorIn = true;

      resetCursor();

      // // TO DO: impl
      //InDevEvent ev;
      //ev.setType(InDevEvent::INDEV_MOUSE_ENTER);
      //ev.setModifier(0);
      //ev.setSource(this);
      //fireInDevEvent(ev);
    }*/

    //MB_DPRINTLN("****** WM_MOUSE MOVE %p", lParam);
    if ((wParam & MK_LBUTTON) ||
        (wParam & MK_MBUTTON) ||
        (wParam & MK_RBUTTON)) {
      // mouse button is pressed --> fire indev event
      //MB_DPRINTLN("****** WM_MOUSE MOVE %p", lParam);
      qsys::InDevEvent ev;
      setUpMouseEvent(msg, wParam, lParam, ev);
      dispatchMouseEvent(1, ev);
    }

    // Generate DOM mousemove event
    // by resending msg to the parent iframe window.
    ::SendMessage(m_hParWnd, msg, wParam, lParam);
    return 0;
  }

/*  case WM_MOUSELEAVE: {
    //MB_DPRINTLN("****** WM_MOUSE LEAVE");
    m_bCursorIn = false;
    TRACKMOUSEEVENT tme;
    tme.cbSize = sizeof tme;
    tme.dwFlags = TME_CANCEL|TME_LEAVE;
    tme.hwndTrack = m_hWnd;
    ::TrackMouseEvent(&tme);

    // // TO DO: impl
    //n InDevEvent ev;
    // ev.setType(InDevEvent::INDEV_MOUSE_ENTER);
    // ev.setModifier(1); // leave flag
    //ev.setSource(this);
    //fireInDevEvent(ev);
    //break;
  }
*/

  case WM_LBUTTONUP:
  case WM_RBUTTONUP: {
    ::ReleaseCapture();

    //MB_DPRINTLN("****** WM_MOUSE LR UP");
    UINT nFlags = wParam;

    nFlags &= ~(MK_LBUTTON|MK_RBUTTON|MK_MBUTTON);
    if (msg==WM_LBUTTONUP)
      nFlags |= MK_LBUTTON;
    else
      nFlags |= MK_RBUTTON;

    qsys::InDevEvent ev;
    setUpMouseEvent(msg, nFlags, lParam, ev);
    dispatchMouseEvent(2, ev);

    break;
  }


    
  case WM_LBUTTONDBLCLK: {
    /*
    POINTS point = MAKEPOINTS(lParam);
    UINT nFlags = wParam;
    // windows doesn't set this flag !!
    nFlags |= MK_LBUTTON;

    InDevEvent ev;
    setUpMouseEvent(nFlags, point, ev);

    ev.setType(InDevEvent::INDEV_LBTN_DBLCLICK);
    fireInDevEvent(ev);
    return 0;
    //break;
     */
  }

  case WM_RBUTTONDBLCLK: {
    /*
    POINTS point = MAKEPOINTS(lParam);
    UINT nFlags = wParam;
    // windows doesn't set this flag !!
    nFlags |= MK_RBUTTON;

    InDevEvent ev;
    setUpMouseEvent(nFlags, point, ev);

    ev.setType(InDevEvent::INDEV_RBTN_DBLCLICK);
    fireInDevEvent(ev);
    return 0;
    //break;
     */
  }

  case WM_MOUSEWHEEL: {
    short zDelta = GET_WHEEL_DELTA_WPARAM(wParam);
    wParam = 0;

    qsys::InDevEvent ev;
    setUpMouseEvent(msg, wParam, lParam, ev);

    ev.setType(qsys::InDevEvent::INDEV_WHEEL);
    ev.setDeltaX((int) zDelta);
    dispatchMouseEvent(3, ev);

    return 0;
  }


  case WM_DESTROY: {
    break;
  }

  case WM_ERASEBKGND: {
    return 1;
  }

  case WM_SHOWWINDOW: {
    break;
  }

  default:
    break;
  }

  return ::DefWindowProc(hWnd, msg, wParam, lParam);
}

/// setup os dependent mouse event parameters
// lParam should be point
// wParam should be modifier flags
void XPCNativeWidgetWin::setUpMouseEvent(UINT msg, WPARAM wParam, LPARAM lParam, qsys::InDevEvent &ev)
{
  // setup locations
  POINTS pt = MAKEPOINTS(lParam);

  ev.setX(pt.x);
  ev.setY(pt.y);

  POINT ptroot = {pt.x, pt.y};
  ::ClientToScreen(m_hWnd, &ptroot);

  ev.setRootX(ptroot.x);
  ev.setRootY(ptroot.y);

  // set modifier
  int modif = 0;
  UINT nFlags = wParam;

  if (nFlags & MK_CONTROL)
    modif |= qsys::InDevEvent::INDEV_CTRL;
  if (nFlags & MK_SHIFT)
    modif |= qsys::InDevEvent::INDEV_SHIFT;
  if (nFlags & MK_LBUTTON)
    modif |= qsys::InDevEvent::INDEV_LBTN;
  if (nFlags & MK_MBUTTON)
    modif |= qsys::InDevEvent::INDEV_MBTN;
  if (nFlags & MK_RBUTTON)
    modif |= qsys::InDevEvent::INDEV_RBTN;

  // ev.setSource(this);
  ev.setModifier(modif);

  return;
}

/* boolean reload (); */
NS_IMETHODIMP XPCNativeWidgetWin::Reload(PRBool *_retval NS_OUTPARAM)
{
  // LOG_DPRINTLN("XPCNativeWidgetWin::Reload Called!@!@!");

  HWND hOldWnd = m_hWnd;
  //HDC hOldDC = m_hDC;

  // Create new window
  m_hWnd = createNativeChildWnd();
  if (!m_hWnd) {
    *_retval = PR_FALSE;
    return NS_ERROR_FAILURE;
  }
  SetWindowLong(m_hWnd, GWL_USERDATA, (LONG)this);

  m_hDC = ::GetDC(m_hWnd);

  bool res = m_pWglView->attach(m_hWnd, m_hDC);
  if (!res) {
    *_retval = PR_FALSE;
    return NS_ERROR_FAILURE;
  }

  // Destroy old window
  ::ShowWindow( hOldWnd, SW_HIDE );
  ::SetParent( hOldWnd, NULL );
  ::DestroyWindow(hOldWnd);

  // Show the new window
  ::ShowWindow( m_hWnd, SW_SHOW );
  ::UpdateWindow( m_hWnd );

  *_retval = PR_TRUE;
  return NS_OK;
}

