//
// XPCOM native widget Cocoa implementation class
//
// $Id: XPCNativeWidgetCocoa.hpp,v 1.9 2010/12/07 14:14:31 rishitani Exp $
//

#ifndef XPC_NATIVE_WIDGET_COCOA_H
#define XPC_NATIVE_WIDGET_COCOA_H

#include "XPCNativeWidget.hpp"

namespace sysdep { class CglView; }
namespace qsys { class InDevEvent; }

class XPCNativeWidgetCocoa : public xpcom::XPCNativeWidget
{
 public:
  XPCNativeWidgetCocoa();
  virtual ~XPCNativeWidgetCocoa();
  
 public:
  virtual nsresult setupImpl(nsIWidget *widget);
  virtual nsresult attachImpl();
  virtual void unloadImpl();
  virtual void resizeImpl(int x, int y, int width, int height);
  
  // Native-event handling methods
  void doRedrawGL();
  // void mouseOver(qsys::InDevEvent &ev);

  // bool dispatchMouseEvent(int nType, qsys::InDevEvent &ev);

  void scrollGesture(float deltaX, float deltaY);
  void pinchGesture(float deltaZ);
  void rotateGesture(float rot);
  void swipeGesture(float deltaX, float deltaY);

 private:
  void *mParentView;
  void *mView;

  sysdep::CglView *m_pCglView;

};

#endif

