//
// XPCOM native widget Cocoa implementation class
//
// $Id: XPCNativeWidgetCocoa.cpp,v 1.14 2010/12/07 14:14:31 rishitani Exp $
//

#include <common.h>

#include "XPCNativeWidgetCocoa.hpp"

//#import <Cocoa/Cocoa.h>
//#import <Carbon/Carbon.h>
//#import <IOKit/pwr_mgt/IOPMLib.h>
//#import <IOKit/IOMessage.h>

#include <prlog.h>
#include <nsDebug.h>

#include <nsCOMPtr.h>
#include <nsIRunnable.h>
#include <nsThreadUtils.h>

#import <AppKit/AppKit.h>
#import <OpenGL/gl.h>
#import <OpenGL/glext.h>
#import <OpenGL/glu.h>

#include <qsys/sysdep/CglView.hpp>
#include <qsys/sysdep/CglDisplayContext.hpp>
#include <qsys/InDevEvent.hpp>

#include "NSOglMolView.hpp"

using gfx::DisplayContext;
using sysdep::CglDisplayContext;

XPCNativeWidgetCocoa::XPCNativeWidgetCocoa()
{
  mParentView=NULL;
  mView=NULL;
  m_pCglView = NULL;
  //MB_DPRINT("XPCNativeWidgetCocoa ctor called.\n");
}

XPCNativeWidgetCocoa::~XPCNativeWidgetCocoa()
{
  //MB_DPRINT("XPCNativeWidgetCocoa dtor called.\n");
}

//////////

nsresult XPCNativeWidgetCocoa::setupImpl(nsIWidget *widget)
{
  mParentView = (void *)(widget->GetNativeData(NS_NATIVE_WIDGET));
  NS_ENSURE_TRUE(mParentView != NULL, NS_ERROR_FAILURE);

  NSView *parView = (NSView *) mParentView;
  //MB_DPRINT("XPCNativeWidgetCocoa::setupImpl ParentView: %p\n", parView);
  MB_DPRINT("ParentView.subviews count: %d\n", parView.subviews.count);
  //id sibling = [[parView subviews] objectAtInde: 0]
    
  int width = getWidth(), height=getHeight();
  if (width<0) width = 100;
  if (height<0) height = 100;
  NSRect rect = NSMakeRect(0,0,width,height);

  // Create NSOglMolView object (defined in NSOglMolView.hpp)
  NSOglMolView *view = [NSOglMolView alloc];
  // NSView *view = [NSButton alloc]];
    
  [view initWithFrameAndOwner: rect owner: this];
  
  //MB_DPRINT("NSView created: %p (%d, %d)\n", view, width, height);
  
  [parView addSubview: view];

  [view setParentView: parView];

  // [view setAcceptsTouchEvents: YES];
  // MB_DPRINT(" superview: %p\n", [view superview]);
  // MB_DPRINT(" nextresponder: %p\n", [view nextResponder]);
  
  mView = view;
  
  return NS_OK;
}

nsresult XPCNativeWidgetCocoa::attachImpl()
{

  if (!mView) {
    MB_DPRINT("XPCNativeWidgetCocoa::attachImpl mView is not initialized!!\n");
    return NS_ERROR_FAILURE;
  }

  qsys::View *ptmp = getQmView().get();
  NS_ENSURE_TRUE(ptmp, NS_ERROR_FAILURE);
  
  //MB_DPRINTLN("OSX bind: view %p type=%s", ptmp, typeid(*ptmp).name());
  MB_DPRINT("OSX bind: view %p type=%s\n", ptmp, typeid(*ptmp).name());

  sysdep::CglView *pCglView = dynamic_cast<sysdep::CglView *>(ptmp);
  if (pCglView==NULL) {
    m_pCglView = NULL;
    LOG_DPRINTLN("OSX bind failed: invalid view %p !!", ptmp);
    return NS_ERROR_FAILURE;
  }
  
  NSOpenGLView *view = (NSOpenGLView *) mView;

  // check for display list sharing
  DisplayContext *pShare = pCglView->getSiblingCtxt();
  if (pShare!=NULL) {
    //MB_DPRINTLN("##### Display list sharing with %p is requested!!", pShare);
    CglDisplayContext *pCglShare = dynamic_cast<CglDisplayContext *>(pShare);
    if (pShare==NULL) {
      MB_DPRINTLN("Warning: Display context %p is not CGL!!", pShare);
    }
    else {
      // CGLContextObj shctxt = pCglShare->getCGLContext();
      NSOpenGLContext *shnsc = (NSOpenGLContext *)pCglShare->getNSGLContext();
      NSOpenGLPixelFormat * pf = [NSOglMolView basicPixelFormat];
      NSOpenGLContext *newctxt = [[[NSOpenGLContext alloc]
				   initWithFormat: pf
				   shareContext: shnsc] autorelease];
      [view setOpenGLContext: newctxt];
    }
  }

  // set cached view ptr
  m_pCglView = pCglView;

  // Get NS and CGL contexts and attach to the View object
  NSOpenGLContext *nsctxt = [view openGLContext];
  CGLContextObj cglctxt = (CGLContextObj) [nsctxt CGLContextObj];
  if (!m_pCglView->attach(nsctxt, cglctxt)) {
    MB_DPRINT("XPCNativeWidgetCocoa::attachImpl attach CGLContextObj failed !!\n");
    return NS_ERROR_FAILURE;
  }
  
  m_pCglView->sizeChanged(getWidth(), getHeight());

  MB_DPRINT("XPCNativeWidgetCocoa::attachImpl OK\n");
  return NS_OK;
}

void XPCNativeWidgetCocoa::unloadImpl()
{
  if (!mView) return;

  NSView *view = (NSView *) mView;
  [view removeFromSuperviewWithoutNeedingDisplay];
  mView=NULL;
  mParentView = NULL;
  //MB_DPRINT("!! XPCNativeWidgetCocoa::unloadImpl called.\n");
}

void XPCNativeWidgetCocoa::resizeImpl(int x, int y, int width, int height)
{
  //MB_DPRINT("!! XPCNativeWidgetCocoa::resizeImpl called %p.\n", mView);

  setSize(width, height);

  if (!mView) return;

  NSView *view = (NSView *) mView;
  NSRect rect = NSMakeRect(x,y,width,height);
  [view setFrame: rect];

  if (m_pCglView==NULL) return;
  m_pCglView->sizeChanged(width, height);

  // MB_DPRINT("ParentView.subviews count: %d\n", view.superview.subviews.count);
}

void XPCNativeWidgetCocoa::doRedrawGL()
{
  if (m_pCglView==NULL) return;

  int curw = getWidth(); 
  int curh = getHeight(); 
  if (curw!=m_pCglView->getWidth() ||
      curh!=m_pCglView->getHeight())
    m_pCglView->sizeChanged(curw, curh);

  m_pCglView->forceRedraw();
}

void XPCNativeWidgetCocoa::scrollGesture(float deltaX, float deltaY)
{
  const float factor = -4.0f;

  if (m_pCglView==NULL) return;

  qlib::Vector4D vec;
  m_pCglView->convXYTrans(deltaX*factor, deltaY*factor, vec);
  // MB_DPRINTLN("drag move %f,%f,%f", vec.x(), vec.y(), vec.z());    
  m_pCglView->setViewCenterDrag(m_pCglView->getViewCenter()-vec);
}

void XPCNativeWidgetCocoa::pinchGesture(float deltaZ)
{
  if (m_pCglView==NULL) return;

  double vw = m_pCglView->getZoom();
  double dw = double(-deltaZ)/200.0 * vw;
  m_pCglView->setZoom(vw+dw);
  m_pCglView->setUpProjMat(-1, -1);
}

void XPCNativeWidgetCocoa::rotateGesture(float rot)
{
  if (m_pCglView==NULL) return;

  m_pCglView->rotateView(0.0f, 0.0f, double(-rot*4.0));
}

void XPCNativeWidgetCocoa::swipeGesture(float deltaX, float deltaY)
{
  if (m_pCglView==NULL) return;

  if (fabs(deltaX)>0.0) {
    double vw = m_pCglView->getSlabDepth();
    double dw = double(deltaX)/5.0 * vw;
    m_pCglView->setSlabDepth(vw+dw);
  }
  else if (fabs(deltaY)>0.0) {
    double vw = m_pCglView->getSlabDepth();
    double dw = double(deltaY)/5.0 * vw;
    m_pCglView->setSlabDepth(vw+dw);
  }

}


