//
// XPCOM native window/widget super class
//
// $Id: XPCNativeWidget.hpp,v 1.5 2010/10/20 15:29:46 rishitani Exp $
//

#ifndef XPC_NATIVE_WIDGET_HPP
#define XPC_NATIVE_WIDGET_HPP

#include <nsCOMPtr.h>
#include <nsIDOMEventListener.h>
#include <nsIBaseWindow.h>
#include <nsIWidget.h>
#include "qINativeWidget.h"

#include <qsys/View.hpp>
#include <qsys/sysdep/MouseEventHandler.hpp>

namespace qsys { class InDevEvent; }

namespace xpcom {

  class XPCNativeWidget : public qINativeWidget, public nsIDOMEventListener
  {
  public:
    XPCNativeWidget();
    virtual ~XPCNativeWidget();

  public:
    NS_DECL_ISUPPORTS
    NS_DECL_NSIDOMEVENTLISTENER
    NS_DECL_QINATIVEWIDGET

  public:
    virtual nsresult setupImpl(nsIWidget *widget) =0;
    virtual nsresult attachImpl() =0;

    virtual void unloadImpl() =0;
    virtual void resizeImpl(int x, int y, int width, int height) =0;

    void setSize(int w, int h) { mWidth = w; mHeight = h;}
    int getWidth() const { return mWidth; }
    int getHeight() const { return mHeight; }

    qsys::ViewPtr getQmView() const { return m_rQmView; }

    bool dispatchMouseEvent(int nType, qsys::InDevEvent &ev);

    void resetCursor();

    bool useMultiTouchPad() const { return m_bUseMultiPad; }

  protected:
    nsCOMPtr<nsIBaseWindow> mBaseWin;
    nsCOMPtr<nsIWidget> mWidget;

    int mWidth, mHeight;

    int m_nSceneID, m_nViewID;
    qsys::ViewPtr m_rQmView;

    qsys::MouseEventHandler m_meh;
    
    bool m_bUseMultiPad;
  };

}

#endif

