//
// XPCOM native window/widget super class imprementation
//
// $Id: XPCNativeWidget.cpp,v 1.8 2011/02/12 13:51:19 rishitani Exp $
//

#include <common.h>

#include "XPCNativeWidget.hpp"

#include "xpcom.hpp"

#include <nsIDOMEvent.h>

#include <qsys/Scene.hpp>
#include <qsys/SceneManager.hpp>
#include <qsys/InDevEvent.hpp>

using namespace xpcom;

NS_IMPL_ISUPPORTS2(XPCNativeWidget, qINativeWidget, nsIDOMEventListener)


XPCNativeWidget::XPCNativeWidget()
{
  mWidth = mHeight = -1;
  printf("!! XPCNativeWidget ctor called.\n");
}

XPCNativeWidget::~XPCNativeWidget()
{
  printf("!! XPCNativeWidget dtor called.\n");
}

/* void setBaseWin (in nsIBaseWindow arg); */
NS_IMETHODIMP XPCNativeWidget::SetBaseWin(nsIBaseWindow *baseWindow)
{
  nsresult rv;

  mBaseWin = baseWindow;

  nsCOMPtr<nsIWidget> widget;
  rv = mBaseWin->GetMainWidget(getter_AddRefs(widget));
  NS_ENSURE_SUCCESS(rv, rv);
  mWidget = widget;

  PRInt32 w, h;
  rv = mBaseWin->GetSize(&w, &h);
  NS_ENSURE_SUCCESS(rv, rv);

  mWidth = w;
  mHeight = h;

  MB_DPRINTLN("XPCNativeWidget::SetupByBaseWin(%p) called. size=(%d, %d)\n",
              baseWindow, w, h);

  return NS_OK;
}

/* void load (); */
NS_IMETHODIMP XPCNativeWidget::Load(PRInt32 nSceneID, PRInt32 nViewID)
{
  nsresult rv;

  NS_ENSURE_TRUE(mWidget, NS_ERROR_FAILURE);

  rv = setupImpl(mWidget);
  NS_ENSURE_SUCCESS(rv, rv);

  ////////

  MB_DPRINTLN("XPCNativeWidget::Load (Scene uid=%d, View uid=%d) called !!", nSceneID, nViewID);
  
  qsys::ScenePtr rsc = qsys::SceneManager::getSceneS(nSceneID);
  NS_ENSURE_TRUE(!rsc.isnull(), NS_ERROR_FAILURE);

  qsys::ViewPtr rvw = rsc->getView(nViewID);
  NS_ENSURE_TRUE(!rvw.isnull(), NS_ERROR_FAILURE);

  m_rQmView = rvw;

  m_nSceneID = nSceneID;
  m_nViewID = nViewID;

  rv = attachImpl();
  NS_ENSURE_SUCCESS(rv, rv);

  return NS_OK;
}

/* void unload (); */
NS_IMETHODIMP XPCNativeWidget::Unload()
{
  MB_DPRINTLN("!! XPCNativeWidget::Unload() called.");
  m_rQmView = qsys::ViewPtr();
  unloadImpl();
  mBaseWin = nsnull;
  mWidget = nsnull;
  return NS_OK;
}

NS_IMETHODIMP XPCNativeWidget::HandleEvent(nsIDOMEvent* aEvent)
{
  // MB_DPRINTLN("XPCNativeWidget::HandleEvent(%p) called, basewin=%p", aEvent, mBaseWin);

  nsAutoString eventType;
  aEvent->GetType(eventType);

  if(eventType.EqualsLiteral("resize")) {
    if (mBaseWin) {
      PRInt32 x, y, cx, cy;
      mBaseWin->GetPositionAndSize(&x,&y,&cx,&cy);
      // MB_DPRINTLN("DOM Resize Event %d, %d, %d, %d", x,y,cx,cy);
      resizeImpl(x,y,cx,cy);
    }
  }


  return NS_OK;
}

/* attribute boolean useMultiPad; */
NS_IMETHODIMP XPCNativeWidget::GetUseMultiPad(PRBool *aUseMultiPad)
{
  *aUseMultiPad = m_bUseMultiPad;
  return NS_OK;
}
NS_IMETHODIMP XPCNativeWidget::SetUseMultiPad(PRBool aUseMultiPad)
{
  m_bUseMultiPad = aUseMultiPad;
  return NS_OK;
}


/// non-DOM mouse event handling
bool XPCNativeWidget::dispatchMouseEvent(int nType, qsys::InDevEvent &ev)
{
  switch (nType) {

    // mouse down event
  case 0:
    m_meh.buttonDown(ev);
    return true;

    // mouse move/dragging event
  case 1:
    if (!m_meh.move(ev)) return true;
    break;

    // mouse up event
  case 2:
    m_meh.buttonUp(ev);
    break;

    // other events
  case 3:
    // non-mouse event
    break;

    // should not be happen
  default:
    MB_DPRINTLN("XPCNativeWidget::dispatchMouseEvent unknown nType %d", nType);
    return true;
    break;
  }

  m_rQmView->fireInDevEvent(ev);
  return true;
}

void XPCNativeWidget::resetCursor()
{
  if (!mWidget)
    return;
  // reset mouse cursor
  nsCursor id = mWidget->GetCursor();
  mWidget->SetCursor(id);
}

/* boolean reload (); */
NS_IMETHODIMP XPCNativeWidget::Reload(PRBool *_retval NS_OUTPARAM)
{
  _retval = PR_FALSE;
  return NS_OK;
}
