// -*-Mode: C++;-*-
//
// Undo/Redo information for style editing
//
// $Id: StyleEditInfo.hpp,v 1.1 2011/05/02 12:42:55 rishitani Exp $

#ifndef QSYS_STYLE_EDIT_INFO_HPP_INCLUDED
#define QSYS_STYLE_EDIT_INFO_HPP_INCLUDED

#include <qsys/qsys.hpp>

#include <qsys/PropEditInfo.hpp>
#include <qsys/UndoManager.hpp>
#include <qsys/Scene.hpp>
#include <qlib/LVariant.hpp>
#include <qlib/ObjectManager.hpp>
#include <qlib/NestedPropHandler.hpp>

namespace qsys {

class StyleSupports;

class StyleEditInfo : public PropEditInfoBase
{
private:
  LString m_newvalue;
  LString m_oldvalue;

  bool m_bNewDef;
  bool m_bOldDef;

public:
  StyleEditInfo() : PropEditInfoBase(), m_bNewDef(false), m_bOldDef(false)
  {
  }

  virtual ~StyleEditInfo();

  /// Setup edit info from old and new names of the styles
  void setup(qlib::uid_t uid, const LString &ov, const LString &nv)
  {
    setTargetUID(uid);
    setPropName("styles");
    m_oldvalue = ov;
    m_newvalue = nv;
  }

  /// Perform undo
  virtual bool undo();

  /// Perform redo
  virtual bool redo();

  virtual bool isUndoable() const;

  virtual bool isRedoable() const;

private:
  void fireStyleEvents(StyleSupports *pTgt);

};

}

#endif
