// -*-Mode: C++;-*-
//
//  Abstract scene exporter class
//

#ifndef QSYS_SCENE_EXPORTER_HPP_INCLUDED
#define QSYS_SCENE_EXPORTER_HPP_INCLUDED

#include "qsys.hpp"

#include "Scene.hpp"
#include "InOutHandler.hpp"

namespace qsys {

using qlib::LString;
//using qlib::FileOutStream;
//using qlib::FileInStream;
//using qlib::StreamBundle;

class QSYS_API SceneExporter : public InOutHandler
{
private:
  ScenePtr m_pClient;

public:
  virtual ~SceneExporter();

  /// Get category ID (obj reader/writer, scene exporter, etc)
  virtual int getCatID() const;

  virtual void write() =0;

  ///////////////////////////////////////////////////////

  // /// main stream
  // virtual LString getPath() const;
  // virtual void setPath(const LString &path);

  // /// sub streams
  // LString getOutPath(const LString &key) const {
  // return m_stream.getPath(key);
  // }
  // void setOutPath(const LString &key, const LString &path) {
  // m_stream.setPath(key, path, true);
  // }
  // 
  // qlib::OutStream *getOutStream(const LString &key) {
  // return m_stream.getOutStream(key);
  // }

  ///////////////////////////////////////////////////////

  /// attach to and lock the target object
  virtual void attach(ScenePtr pScene);
    
  /// detach from the target object
  virtual ScenePtr detach();
    
  ScenePtr getClient() const { return m_pClient; }

};

}

#endif // ABSTRACT_SCENE_WRITER_HPP_INCLUDED_

