// -*-Mode: C++;-*-
//
// Object writer
//
// $Id: ObjWriter.hpp,v 1.4 2010/10/31 13:36:49 rishitani Exp $

#ifndef QSYS_OBJECT_WRITER_HPP__
#define QSYS_OBJECT_WRITER_HPP__

#include "qsys.hpp"
#include "Object.hpp"

#include <qlib/LStream.hpp>
#include <qlib/LExceptions.hpp>
#include "InOutHandler.hpp"

using qlib::LString;

namespace qsys {

  class QSYS_API ObjWriter : public InOutHandler
  {
    MC_SCRIPTABLE;

  private:
    ObjectPtr m_pTarget;
    
  protected:
    template <class T>
    T *getTarget() const {
      return static_cast<T *>(m_pTarget.get());
    }

  public:
    ObjWriter();
    virtual ~ObjWriter();

    //////////////////////////////////////////////
  
    /** attach to and lock the target object */
    virtual void attach(ObjectPtr pObj);
    
    /** detach from the target object */
    virtual ObjectPtr detach();
    
    /** write to the stream */
    virtual bool write(qlib::OutStream &outs) =0;
    
    /** get the nickname of this writer (referred from script interface) */
    virtual const char *getName() const =0;

    /** get file-type description */
    virtual const char *getTypeDescr() const =0;
    
    /** get file extension */
    virtual const char *getFileExt() const =0;
    
    virtual bool canHandle(ObjectPtr pobj) const =0;

    virtual int getCatID() const { return IOH_CAT_OBJWRITER; }

    //////////////////////////////////////////////
    // Convenience methods

    /// write to the path or stream set by setPath() or setStream()
    void write();
    
  };
}

#endif // OBJECT_READER_H__

