// -*-Mode: C++;-*-
//
// object reader
//
// $Id: ObjReader.cpp,v 1.6 2011/01/03 16:47:05 rishitani Exp $

#include <common.h>

#include "ObjReader.hpp"
#include <qlib/FileStream.hpp>
// #include <qlib/ClassRegistry.hpp>
// #include <qlib/LClassUtils.hpp>

#include <qlib/LDOM2Tree.hpp>

using namespace qsys;

// MC_SCRIPTABLE_EMPTY_IMPL(ObjReader);
// MC_DYNCLASS_IMPL(ObjReader, ObjReader, qlib::LSpecificClass<ObjReader>);

ObjReader::ObjReader()
{
}

ObjReader::~ObjReader()
{
}

/** attach to and lock the target object */
void ObjReader::attach(ObjectPtr pObj)
{
  m_pTarget = pObj;
}
    
/** detach from the target object */
ObjectPtr ObjReader::detach()
{
  ObjectPtr pret = m_pTarget;
  m_pTarget = ObjectPtr();
  return pret;
}

ObjectPtr ObjReader::load(qlib::InStream &ins)
{
  ObjectPtr robj = createDefaultObj();
  attach(robj);
  if (!read(ins))
    return ObjectPtr();
  return detach();
}

void ObjReader::read()
{
  // TO DO: support non-local-file streams
  //qlib::FileInStream fis;
  //fis.open(getPath());
  //read(fis);
  //fis.close();
  {
    qlib::InStream *pIn = createInStream();
    read(*pIn);
    pIn->close();
    delete pIn;
  }
  
  m_pTarget->setSourceType(getName());
  m_pTarget->setSource(getPath());

  // save reader options
  qlib::LDom2Tree tree("ropts");
  
  // Reader(options) --> LDOM2 tree
  tree.serialize(this, false);
  tree.dump();
  m_pTarget->setReaderOpts(tree.detach());

  return;
}


