// -*-Mode: C++;-*-
//
// Camera: object for the set of view setting
//
// $Id: Camera.hpp,v 1.7 2011/01/03 16:47:05 rishitani Exp $
//

#ifndef QSYS_CAMERA_HPP_INCLUDE_
#define QSYS_CAMERA_HPP_INCLUDE_

#include "qsys.hpp"

#include <qlib/ObjectManager.hpp>
#include <qlib/LScrVector4D.hpp>
#include <qlib/LScrQuat.hpp>
#include "ObjectEvent.hpp"

namespace qsys {

using qlib::LString;
using qlib::Vector4D;
using qlib::LScrVector4D;
using qlib::LQuat;
using qlib::LScrQuat;


class QSYS_API Camera :
  public qlib::LSimpleCopyScrObject
{
  MC_SCRIPTABLE;
  MC_CLONEABLE;

  /////////////////////////////

public:
  
  LString m_name;

  /// Stereo mode
  int m_nStereoMode;
  
  /// Stereo mode ID
  enum {
    CSM_NONE =0,
    CSM_PARA =1,
    CSM_CROSS =2,
    CSM_HW_QBUF =3,
    CSM_HW_AUTO =4,
  };

  /// inter-ocular distance
  double m_fStereoDist;

  /// Projection mode
  bool m_fPerspec;

  /// View center position
  Vector4D m_center;

  /// View rotation quaternion
  LQuat m_rotQuat;

  /// Depth of the slab
  double m_fSlabDepth;

  /// Zoom
  double m_fZoom;

  /// center mark type
  int m_nCenterMark;

  /// Center mark ID
  enum {
    CCM_NONE,
    CCM_CROSS,
    CCM_AXIS,
    CCM_CUBE
  };

public:
  LScrQuat getRotQuat() const {
    return LScrQuat(m_rotQuat);
  }
  void setRotQuat(const LScrQuat &q) {
    m_rotQuat = LQuat(q);
  }

  LScrVector4D getCenter() const {
    return LScrVector4D(m_center);
  }
  void setCenter(const LScrVector4D &q) {
    m_center = LScrVector4D(q);
  }

  //////////

  Camera();

  Camera(const Camera&r) {
    m_fSlabDepth = r.m_fSlabDepth;
    m_fZoom = r.m_fZoom;
    m_fStereoDist = r.m_fStereoDist;
    m_center = r.m_center;
    m_rotQuat = r.m_rotQuat;
    m_nStereoMode = r.m_nStereoMode;
    m_fPerspec = r.m_fPerspec;
    m_nCenterMark = r.m_nCenterMark;
  }
  
  const Camera &operator=(const Camera &r) {
    if (&r != this) {
      m_fSlabDepth = r.m_fSlabDepth;
      m_fZoom = r.m_fZoom;
      m_fStereoDist = r.m_fStereoDist;
      m_center = r.m_center;
      m_rotQuat = r.m_rotQuat;
      m_nStereoMode = r.m_nStereoMode;
      m_fPerspec = r.m_fPerspec;
      m_nCenterMark = r.m_nCenterMark;
    }
    return *this;
  }

};

/// Camera-related event
class QSYS_API CameraEvent : public ObjectEvent
{
private:
  
public:
  int m_nEvtType;
  LString m_name;
  
  //////////
  
public:
  CameraEvent()
       : ObjectEvent()
    {}

  CameraEvent(const CameraEvent &ev)
       : ObjectEvent(ev)
    {}

  virtual ~CameraEvent();

  virtual LCloneableObject *clone() const;

  //////////

  virtual LString getJSON() const;
  virtual bool getCategory(LString &category, int &nSrcType, int &nEvtType) const;
};

}

#endif
