// -*-Mode: C++;-*-
//
// String input/output streams
//
// $Id: StringStream.hpp,v 1.2 2009/05/04 18:01:21 rishitani Exp $

#ifndef STRING_INPUT_OUTPUT_STREAM_H__
#define STRING_INPUT_OUTPUT_STREAM_H__

#include "FormatStream.hpp"
#include "LString.hpp"
#include "LChar.hpp"
#include "ArrayIOImpl.hpp"
#include "qlib.hpp"

namespace qlib {

  /** string input stream */
  class QLIB_API StrInStream : public InStreamAdaptor
  {
    
  private:
    typedef detail::ArrayInImpl char_impl;
    sp<char_impl> m_pimpl;
    
  public:
    explicit StrInStream(const LString &in);
    
    /** construction from null-terminated char array */
    explicit StrInStream(const char *in);

    explicit StrInStream(const char *in, int nlen);
    
    virtual ~StrInStream();
    
    /** copy ctor */
    StrInStream(const StrInStream &r);

    /** copy operator */
    const StrInStream &operator=(const StrInStream &arg);

    virtual bool ready();

    virtual int read();
  
    virtual int read(char *buf, int off, int len);

    virtual void close();

    /** get implementation */
    virtual impl_type getImpl() const;

  }; // class StrInStream

  ////////////////////////////////////////

  /** superclass of file output stream */
  class QLIB_API StrOutStream : public OutStreamAdaptor
  {

  private:
    sp<detail::ArrayOutImpl> m_pimpl;

  public:
    StrOutStream() : m_pimpl(new detail::ArrayOutImpl())
    {
    }
    
    /** copy ctor */
    StrOutStream(const StrOutStream &r) :m_pimpl(r.m_pimpl)
    {
    }

    /** copy operator */
    const StrOutStream &operator=(const StrOutStream &arg) {
      if(&arg!=this){
	m_pimpl = arg.m_pimpl;
      }
      return *this;
    }

    virtual ~StrOutStream();
    
    virtual int write(const char *buf, int off, int len);
    
    virtual void write(int b);

    virtual void flush();

    virtual void close();

    /** get implementation */
    virtual impl_type getImpl() const;

    /** get the written string */
    LString getString() const {
      const std::deque<char> *pdat = m_pimpl->getData();
      int n = pdat->size();
      std::deque<char>::const_iterator iter = pdat->begin();
      LString ret('\0', n);
      int i;
      for ( i=0; iter!=pdat->end(); ++iter, ++i)
	ret[i] = *iter;
      return ret;
    }
    
    /** get the written binary data */
    char *getData(int &nsize) const {
      const std::deque<char> *pdat = m_pimpl->getData();
      nsize = pdat->size();
      if (nsize<=0) return NULL;
      std::deque<char>::const_iterator iter = pdat->begin();
      char *ret = new char[nsize];
      int i;
      for ( i=0; iter!=pdat->end(); ++iter, ++i)
	ret[i] = *iter;
      return ret;
    }

  };
  
} // namespace qlib

#endif
