// -*-Mode: C++;-*-
//
// String input/output streams
//
// $Id: StringStream.cpp,v 1.1 2008/01/02 13:40:16 rishitani Exp $

#include <common.h>

#include "StringStream.hpp"

#include "LString.hpp"

using namespace qlib;

StrInStream::StrInStream(const LString &in)
  : m_pimpl(new char_impl(in.c_str(), in.length()))
{
}

StrInStream::StrInStream(const char *in)
  : m_pimpl(new char_impl(in, LChar::length(in)))
{
}

StrInStream::StrInStream(const char *in, int nlen)
  : m_pimpl(new char_impl(in, nlen))
{
}

StrInStream::~StrInStream() 
{
}

/** copy ctor */
StrInStream::StrInStream(const StrInStream &r) :m_pimpl(r.m_pimpl)
{
}

/** copy operator */
const StrInStream &StrInStream::operator=(const StrInStream &arg)
{
  if(&arg!=this){
    m_pimpl = arg.m_pimpl;
  }
  return *this;
}

bool StrInStream::ready() {
  return m_pimpl->ready();
}

int StrInStream::read() {
  return m_pimpl->read();
}

int StrInStream::read(char *buf, int off, int len) {
  return m_pimpl->read(buf, off, len);
}

void StrInStream::close() {
  m_pimpl->i_close();
}

/** get implementation */
StrInStream::impl_type StrInStream::getImpl() const
{
  return m_pimpl;
}

////////////////////////////////////////////////////////////////

StrOutStream::~StrOutStream() {
}
    
//////////////////////////////////////////////////////

int StrOutStream::write(const char *buf, int off, int len) {
  return m_pimpl->write(buf, off, len);
}
    
void StrOutStream::write(int b) {
  return m_pimpl->write(b);
}

void StrOutStream::flush() {
  m_pimpl->flush();
}

void StrOutStream::close() {
  m_pimpl->o_close();
}

/** get implementation */
StrOutStream::impl_type StrOutStream::getImpl() const {
  return m_pimpl;
}
