// -*-Mode: C++;-*-
//
// Stream bundle class
//
// $Id: StreamBundle.cpp,v 1.2 2011/01/03 16:47:05 rishitani Exp $

#include <common.h>
#include "StreamBundle.hpp"
#include "LExceptions.hpp"

using namespace qlib;
#if 0
namespace qlib {

struct SBEntry
{
  SBEntry() : bModeOut(false), bOwned(false), pOut(NULL), pIn(NULL) {}

  LString strName;
  bool bModeOut;
  bool bOwned;
  qlib::OutStream *pOut;
  qlib::InStream *pIn;
  
  void closeStream()
    {
      if (bOwned) {
        if (pOut!=NULL) {
          delete pOut;
          pOut = NULL;
        }
        if (pIn!=NULL) {
          delete pIn;
          pIn = NULL;
        }
        bOwned = false;
      }
    }

  void assignOutStream()
    {
      FileOutStream *pFOut = new FileOutStream;
      try {
        pFOut->open(strName);
      }
      catch (...) {
        delete pFOut;
        throw;
      }
      bModeOut = true;
      pOut = pFOut;
      bOwned = true;
    }

  void assignInStream()
    {
      FileInStream *pFIn = new FileInStream;
      try {
        pFIn->open(strName);
      }
      catch (...) {
        delete pFIn;
        throw;
      }
      bModeOut = false;
      pIn = pFIn;
      bOwned = true;
    }

};
}

using namespace qlib;

void StreamBundle::setStreamImpl(const LString &key, const LString &path,
                                 bool bModeOut, LStream *pstr)
{
  SBEntry *pE = new SBEntry;
  pE->bModeOut = bModeOut;
  pE->bOwned = false;

  if (!path.isEmpty()) {
    pE->strName = path;
    pE->pOut =NULL;
    pE->pIn = NULL;
  }
  else {
    pE->strName = "";
    if (bModeOut) {
      pE->pOut = static_cast<OutStream*>(pstr);
      pE->pIn = NULL;
    }
    else {
      pE->pIn = static_cast<InStream*>(pstr);
      pE->pOut = NULL;
    }
  }
  m_data.insert(data_t::value_type(key, pE));
}

SBEntry *StreamBundle::getEntry(const LString &key) const
{
  data_t::const_iterator iter = m_data.find(key);
  if (iter==m_data.end())
    return NULL;
  return iter->second;
}
#endif

StreamBundle::StreamBundle()
{
}

StreamBundle::~StreamBundle()
{
//  BOOST_FOREACH(data_t::value_type &elem, m_data) {
//    elem.second->closeStream();
//    delete elem.second;
//  }
}

#if 0
///////////////////////////////////////////
// Input specific methods

void StreamBundle::setInStream(const LString &key, qlib::InStream *pins)
{
  if (m_data.find(key)!=m_data.end()) {
    LString msg = LString::format("Stream %s exists.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return;
  }
  setStreamImpl(key, LString(), false, pins);
}

qlib::InStream *StreamBundle::getInStream(const LString &key)
{
  SBEntry *pE = getEntry(key);
  if (pE==NULL) {
    LString msg = LString::format("Stream %s is not found.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return NULL;
  }

  if (pE->bModeOut) {
    LString msg = LString::format("Stream mode %s is not for output.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return NULL;
  }

  if (pE->pIn==NULL) {
    pE->assignInStream();
  }

  return pE->pIn;
}

///////////////////////////////////////////
// Output specific methods

void StreamBundle::setOutStream(const LString &key, qlib::OutStream *pouts)
{
  if (m_data.find(key)!=m_data.end()) {
    LString msg = LString::format("Stream %s exists.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return;
  }
  setStreamImpl(key, LString(), true, pouts);
}

qlib::OutStream *StreamBundle::getOutStream(const LString &key)
{
  SBEntry *pE = getEntry(key);
  if (pE==NULL) {
    LString msg = LString::format("Stream %s is not found.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return NULL;
  }

  if (!pE->bModeOut) {
    LString msg = LString::format("Stream mode %s is not for output.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return NULL;
  }

  if (pE->pOut==NULL) {
    pE->assignOutStream();
  }

  return pE->pOut;
}

///////////////////////////////////////////
// I/O common methods

void StreamBundle::setPath(const LString &key, const LString &path, bool bOut)
{
  SBEntry *pE = getEntry(key);
  if (pE==NULL) {
    setStreamImpl(key, path, bOut, NULL);
    return;
  }

  if (pE->pOut!=NULL || pE->pIn!=NULL) {
    LString msg = LString::format("Stream %s exists.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return;
  }
  else {
    // Overwrite existing bundle entry
    pE->strName = path;
    pE->bModeOut = bOut;
    pE->bOwned = false;
    return;
  }
}

LString StreamBundle::getPath(const LString &key) const
{
  SBEntry *pE = getEntry(key);
  if (pE==NULL) {
    LString msg = LString::format("Stream %s is not found.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return NULL;
  }

  return pE->strName;
}

void StreamBundle::closeStream(const LString &key)
{
  SBEntry *pE = getEntry(key);
  if (pE==NULL) {
    LString msg = LString::format("Stream %s is not found.", key.c_str());
    MB_THROW(qlib::IOException, msg);
    return;
  }
  pE->closeStream();
}

#endif

