// -*-Mode: C++;-*-
//
// RangeSet : set of integer ranges
//
// $Id: RangeSet.cpp,v 1.4 2011/04/16 12:44:39 rishitani Exp $

#include <common.h>
#include <limits>

#include "RangeSet.hpp"

using namespace qlib;

LScrRangeSet::~LScrRangeSet()
{
}

LScrRangeSet LScrRangeSet::negate() const
{
  const int pinfty = std::numeric_limits<int>::max();
  const int minfty = std::numeric_limits<int>::min();
  RangeSet retval;
  
  if (m_data.empty()) {
    retval.append(minfty, pinfty);
    return retval;
  }

  const Range &hd = m_data.front();
  const Range &tl = m_data.back();

  if (minfty<hd.nstart) {
    retval.append(minfty, hd.nstart);
  }

  if (hd.nend<pinfty) {
    retval.append(hd.nend, pinfty);
  }

  if (m_data.size()==1) {
    return retval;
  }

  data_t::const_iterator iter = m_data.begin(), iter2;
  iter2 = iter;
  ++iter2;
  for ( ; iter2!=m_data.end(); ++iter, ++iter2)
    retval.append(iter->nend, iter->nstart);

  return retval;
}


void LScrRangeSet::dump() const
{
  if (m_data.empty()) {
    LOG_DPRINTLN("(empty)");
    return;
  }

  data_t::const_iterator iter = m_data.begin();
  for (; iter!=m_data.end(); ++iter) {
    LOG_DPRINT("[%d-%d) ", iter->nstart, iter->nend);
  }  
  LOG_DPRINTLN("");
}

////////////////////////////////

LString LScrRangeSet::toString() const
{
  if (m_data.empty())
    return LString();

  LString rval;

  data_t::const_iterator iter = m_data.begin();
  for (; iter!=m_data.end(); ++iter) {
    int nstart = iter->nstart, nend = iter->nend;

    if (iter!=m_data.begin())
      rval += ",";

    if (nstart==nend-1)
      rval += LString::format("%d",nstart);
    else
      rval += LString::format("%d:%d",nstart,nend-1);
  }  

  return rval;


/*
  LString rval;

  data_t::const_iterator iter = m_data.begin();
  for (int i=0; iter!=m_data.end(); ++iter, ++i) {
    if (i>0)
      rval += ", ";
    rval += LString::format("[%d-%d)", iter->nstart, iter->nend);
  }  

  return rval;
*/
}

bool LScrRangeSet::fromString(const LString &arg)
{
  // TO DO: implementation
  return false;
}

