// -*-Mode: C++;-*-
//
// String.cc
//   LString class LString
//
// $Id: LWrapper.cpp,v 1.1 2010/03/13 14:19:52 rishitani Exp $

#include <common.h>

#include "LWrapper.hpp"

using namespace qlib;

LWrapperImpl::LWrapperImpl()
{
}

LWrapperImpl::~LWrapperImpl()
{
  qlib::FuncMap::cleanup();
}

bool LWrapperImpl::getPropSpec(const qlib::LString &name,
                               PropSpec *pspec) const
{
  if (!hasProp(name))
    return false;
  if (pspec==NULL)
    return true;
  pspec->bReadOnly = !hasWProp(name);
  pspec->bHasDefault = hasDefVal(name);
  pspec->type_name = getPropTypeName(name);
  if (pspec->type_name.equals("enum")) {
    if (pspec->pEnumDef!=NULL)
      delete pspec->pEnumDef;
    pspec->pEnumDef = new EnumDef;
    getEnumDefSet(name, *(pspec->pEnumDef));
  }
  return true;
}

//static
void LWrapperImpl::convToBoolValue(LBool &aDest, const LVariant &aSrc, const LString &propname)
{
  if (aSrc.isString()) {
    const LString &strval = aSrc.getStringValue();
    if (strval.equalsIgnoreCase("true") ||
        strval.equalsIgnoreCase("on") ||
        strval.equalsIgnoreCase("yes")) {
      aDest = true;
      return;
    }
    if (strval.equalsIgnoreCase("false") ||
        strval.equalsIgnoreCase("off") ||
        strval.equalsIgnoreCase("no")) {
      aDest = false;
      return;
    }
    
    LString msg = LString::format("Cannot cast string (%s) to boolean",
                                  strval.c_str());
    MB_THROW(InvalidCastException, msg);
  }
  else
    aDest = aSrc.getBoolValue();
}

