// -*-Mode: C++;-*-
//
// que library exception classes
//
// $Id: LExceptions.hpp,v 1.3 2010/12/26 12:26:17 rishitani Exp $

#ifndef QUE_LIBRARY_EXCEPTIONS_HPP_
#define QUE_LIBRARY_EXCEPTIONS_HPP_

//////////////////////////////////////

#undef MB_DECL_EXCPT_CLASS
#define MB_DECL_EXCPT_CLASS(CLASSNAME, SUPCLSNAME) \
class CLASSNAME : public SUPCLSNAME { \
public: \
  CLASSNAME() throw () {} \
  explicit CLASSNAME(const qlib::LString &msg) throw () : SUPCLSNAME(msg) {} \
};\


#undef MB_THROW
#ifdef __func__
#define MB_THROW(TYPE, MSG) \
  { TYPE __e(MSG);\
     __e.setFileName(__FILE__);\
     __e.setLineNo(__LINE__);\
     __e.setFuncName(__func__);\
     throw __e; }
#else
#define MB_THROW(TYPE, MSG) \
  { TYPE __e(MSG);\
     __e.setFileName(__FILE__);\
     __e.setLineNo(__LINE__);\
     throw __e; }
#endif

//////////////////////////////////////

#include "qlib.hpp"

#include <exception>
#include "LString.hpp"

namespace qlib {
  class LException {
  private:
    LString m_msg;
    LString m_fileName;
    LString m_funcName;
    int m_lineNo;

  public:
    LException() throw () {}
    explicit LException(const LString &msg) throw () 
      : m_msg(msg), m_fileName("unknown"), m_funcName("unknown"), m_lineNo(-1)
    {
    }

    virtual ~LException() throw () {}

    virtual LString getMsg() const throw () { return m_msg; }
    virtual void setMsg(const LString &msg) throw () { m_msg = msg; }

    void setFileName(const char *str) const throw () { ((LException *)this)->m_fileName = str; }
    void setFuncName(const char *str) throw () { m_funcName = str; }
    void setLineNo(int n) throw () { m_lineNo = n; }

    LString getFmtMsg() const throw () {
      return LString::format("%s @ %s in %s:%d", m_msg.c_str(), m_funcName.c_str(), m_fileName.c_str(), m_lineNo);
    }
  };

  /** superclass of general runtime exceptions */
  MB_DECL_EXCPT_CLASS(RuntimeException, LException);

  MB_DECL_EXCPT_CLASS(OutOfMemoryException, RuntimeException);

  MB_DECL_EXCPT_CLASS(IndexOutOfBoundsException, RuntimeException);
  
  MB_DECL_EXCPT_CLASS(NullPointerException, RuntimeException);

  MB_DECL_EXCPT_CLASS(IllegalArgumentException, RuntimeException);
  
  MB_DECL_EXCPT_CLASS(InvalidCastException, RuntimeException);

  MB_DECL_EXCPT_CLASS(SecurityException, RuntimeException);

  MB_DECL_EXCPT_CLASS(InterruptedException, RuntimeException);

  template <typename _Type>
  _Type *ensureNotNull(_Type *pArg) {
    if (pArg==NULL) {
      MB_THROW(NullPointerException, "ensureNotNull failed");
    }
    return pArg;
  }

  ////////////////////////////////////////////////

  /** superclass of general I/O exceptions */
  MB_DECL_EXCPT_CLASS(IOException, LException);

  /** End-of-file exceptions */
  MB_DECL_EXCPT_CLASS(EOFException, IOException);

  /** File format exception */
  MB_DECL_EXCPT_CLASS(FileFormatException, IOException);

}

#endif // QUE_LIBRARY_EXCEPTIONS_HPP_

