// -*-Mode: C++;-*-
//
//  Event manager
//
//  $Id: EventManager.hpp,v 1.3 2010/10/24 14:06:18 rishitani Exp $

#include "qlib.hpp"

#include "SingletonBase.hpp"

#ifndef QLIB_EVENT_MANAGER_HPP_
#define QLIB_EVENT_MANAGER_HPP_

namespace qlib {

class LEvent;

class QLIB_API LEventCasterBase
{
public:

  LEventCasterBase() : m_fLock(false) {}

  virtual void fireEvent(LEvent *pEvent) =0;

  /////////////////////////////////////////
  // Lock
  //
  
  void lock() const {
    m_fLock = true;
  }
  
  void unlock() const {
    m_fLock = false;
  }
  
  bool isLocked() const {
    return m_fLock;
  }

protected:
  mutable bool m_fLock;
  
};

class EventCastLocker
{
private:
  const LEventCasterBase *m_pCaster;

public:
  EventCastLocker(const LEventCasterBase *pCaster)
       : m_pCaster(pCaster)
    {
      m_pCaster->lock();
    }

  ~EventCastLocker()
    {
      m_pCaster->unlock();
    }
};

/**
    Event manager
 */
class QLIB_API EventManager : public SingletonBase<EventManager>
{
private:
#ifdef HAVE_BOOST_THREAD
  boost::thread::id m_mainthr;
  mutable boost::mutex m_mu;
#endif  

  typedef std::pair<LEvent *, LEventCasterBase *> tuple_t;

  std::list<tuple_t> m_pending;

public:
  EventManager();
  virtual ~EventManager();
  
  /////////////////////////////
  
  bool isMainThread() const;
  
  void delegateEventFire(const LEvent *pEvent, LEventCasterBase *pCaster);

  void messageLoop();

public:
  
};

}

#endif // LOGGER_H__


