//
// Event manager
//
// $Id: EventManager.cpp,v 1.2 2010/09/12 12:52:38 rishitani Exp $

#include <common.h>

#include "EventManager.hpp"
#include "LEvent.hpp"

using namespace qlib;

SINGLETON_BASE_IMPL(EventManager);

EventManager::EventManager()
{
#ifdef HAVE_BOOST_THREAD
  m_mainthr = boost::this_thread::get_id();
#endif  
}

EventManager::~EventManager()
{
}

bool EventManager::isMainThread() const
{
#ifdef HAVE_BOOST_THREAD
  if (m_mainthr != boost::this_thread::get_id())
    return false;
#endif  
  return true;
}

void EventManager::delegateEventFire(const LEvent *pEvent, LEventCasterBase *pCaster)
{
  boost::mutex::scoped_lock lk(m_mu);
  m_pending.push_back(tuple_t(static_cast<LEvent *>(pEvent->clone()), pCaster));
}

void EventManager::messageLoop()
{
  boost::mutex::scoped_lock lk(m_mu);

  while (m_pending.size()>0) {
    tuple_t tup = m_pending.front();
    m_pending.pop_front();
    
    LEvent *pEvent =tup.first;
    LEventCasterBase *pCaster = tup.second;

    pCaster->fireEvent(pEvent);
    delete pEvent;
  }
}

