// -*-Mode: C++;-*-
//
// Array.h
//   1D array class Array
//
// $Id: Array.hpp,v 1.3 2010/11/23 11:19:33 rishitani Exp $

#ifndef ARRAY_1D_H__
#define ARRAY_1D_H__

namespace qlib {

  template <class _Type>
  class Array
  {
  private:
    _Type *m_array;

    // number of entries;
    int m_nSize;
    
  public:
    /**
       Make empty array (we must allocate memory by resize() later.)
    */
    Array() : m_array(NULL), m_nSize(0)
    {
    }
    
    /**
       Make array with size sz
    */
    explicit Array(int sz)
      : m_nSize(sz)
    {
      m_array = new _Type[sz];
    }

    /**
       Make array with size sz and initialize all elements by ini
    */
    explicit Array(const _Type &ini, int sz)
      : m_nSize(sz)
    {
      m_array = new _Type[sz];
      for (int i=0; i<sz; i++)
        m_array[i] = ini;
    }

    /**
       Make array from existing C array
    */
    explicit Array(int sz, const _Type *p)
      : m_nSize(sz)
    {
      m_array = new _Type[sz];
      for (int i=0; i<sz; i++)
        m_array[i] = p[i];
    }
    
    /**
       Copy constructor
    */
    Array(const Array<_Type> &arg)
      : m_nSize(arg.m_nSize)
    {
      m_array = new _Type[arg.m_nSize];
      for(int i=0; i<arg.m_nSize; i++)
        m_array[i] = arg.m_array[i];
    }
    
    ~Array() {
      if(m_array!=NULL) delete [] m_array;
    }

    /////////////////////////////////////////////////////
    // member methods

    int size() const { return m_nSize; }
    int getSize() const { return size(); }

    void resize(int newsz) {
      if (m_array!=NULL) {
	delete [] m_array;
	m_array = NULL;
        m_nSize = 0;
      }
      
      if (newsz>0) {
        m_array = new _Type[newsz];
        m_nSize = newsz;
      }
    }

    const _Type &at(int i) const {
      MB_ASSERT(i>=0); MB_ASSERT(i<m_nSize);
      return m_array[i];
    }

    _Type &at(int i) {
      MB_ASSERT(i>=0); MB_ASSERT(i<m_nSize);
      return m_array[i];
    }

    const _Type *data() const {
      return m_array;
    }

    _Type *data() {
      return m_array;
    }

    /////////////////////////////////////////////////////
    // member operators

    operator const _Type *() const {
      return data();
    }

    const Array<_Type> &operator =(const Array<_Type> &arg)
    {
      if(&arg!=this){
	if(m_array!=NULL)
	  delete [] m_array;
	m_array = new _Type[arg.getSize()];

	m_nSize = arg.m_nSize;
	for(int i=0; i<arg.getSize(); i++)
	  m_array[i] = arg[i];
      }
      return *this;
    }

    const Array<_Type> &operator =(const _Type &arg)
    {
      for(int i=0; i<getSize(); i++)
	m_array[i] = arg;
      return *this;
    }

    /** *= operator (scaling) */
    const Array<_Type> &operator*=(const _Type &arg)
    {
      for(int i=0; i<getSize(); i++)
	m_array[i] *= arg;
      return *this;
    }

    const _Type &operator [](int i) const {
      return at(i);
    }

    _Type &operator [](int i) {
      return at(i);
    }
  };

#if 0
template <class T>
class Array
{
private:
  T *m_array;

  // number of entries;
  int m_nSize;
  int m_nRows;
  int m_nSecs;

public:
  Array() : m_array(NULL), m_nSize(0)
    {
    }

  Array(int sz)
       : m_nSize(sz)
    {
      m_array = new T[sz];
    }

  Array(int sz, const T *p)
       : m_nSize(sz)
    {
      m_array = new T[sz];
      for (int i=0; i<sz; i++)
        m_array[i] = p[i];
    }

  Array(const Array<T> &arg)
       : m_nSize(arg.m_nSize)
    {
      m_array = new T[arg.m_nSize];
      for(int i=0; i<arg.m_nSize; i++)
        m_array[i] = arg.m_array[i];
    }

  ~Array() {
    if(m_array!=NULL) delete [] m_array;
  }

  /////////////////////////////////////////////////////
  // member methods

  int getSize() const { return m_nSize; }
  int size() const { return m_nSize; }

  const T &at(int i) const {
    MB_ASSERT(i>=0); MB_ASSERT(i<m_nSize);
    return m_array[i];
  }

  T &at(int i) {
    MB_ASSERT(i>=0); MB_ASSERT(i<m_nSize);
    return m_array[i];
  }

  /////////////////////////////////////////////////////
  // member operators

  operator const T *() const { return m_array; }

  const Array<T> &operator =(const Array<T> &arg)
  {
    if(&arg!=this){
      if(m_array!=NULL)	delete [] m_array;
      m_array = new T[arg.getSize()];

      m_nSize = arg.m_nSize;
      for(int i=0; i<arg.getSize(); i++)
	m_array[i] = arg[i];
    }
    return *this;
  }

  const T &operator [](int i) const {
    MB_ASSERT(i>=0); MB_ASSERT(i<m_nSize);
    return m_array[i];
  }

  T &operator [](int i) {
    MB_ASSERT(i>=0); MB_ASSERT(i<m_nSize);
    return m_array[i];
  }
};
#endif

}

#endif // ARRAY_1D_H__
