#!/usr/bin/perl

my $arch = "MacOSX-Intel";
my $inst_top = $ARGV[0];
my $top_srcdir = $ARGV[1];
my $povray_dir = $ARGV[2];

if (!-d $inst_top) {
    die "inst_top ($inst_top) not found.\nUsage: $0 <inst_top> <top_srcdir> <povray_dir>\n";
}
if (!-d $top_srcdir) {
    die "top_srcdir ($top_srcdir) not found.\nUsage: $0 <inst_top> <top_srcdir> <povray_dir>\n";
}
if (!-d $povray_dir) {
    die "povray_dir ($povray_dir) not found.\nUsage: $0 <inst_top> <top_srcdir> <povray_dir>\n";
}

my $RSYNC = "rsync";

my $dist_top; 
open(IN, "$top_srcdir/version.hpp") || die "$?:$!";
while (<IN>) {
    if (/PRODUCTVER\s+(\d+),(\d+),(\d+),(\d+)/) {
	$dist_top = "CueMol2-$1.$2.$3.$4-$arch"; 
    }
}
close(IN);

print "output: $dist_top\n";

#####

my $TARGET_POV_DIR = "$dist_top/CueMol2.app/Contents/Resources/povray";
system("mkdir -p $TARGET_POV_DIR/bin");
system("cp $povray_dir/unix/povray $TARGET_POV_DIR/bin/");
system("cp -r $povray_dir/include $TARGET_POV_DIR");

system("perl $top_srcdir/osxbuild/pkg-dmg --source $dist_top --target ${dist_top}+povray.dmg"); 
