// -*-Mode: C++;-*-
//
//  molecular surface renderer
//
// $Id: MolSurfRenderer.hpp,v 1.8 2011/04/02 07:57:34 rishitani Exp $

#ifndef MOLSURF_RENDERER_H__
#define MOLSURF_RENDERER_H__

#include "surface.hpp"

#include <qlib/mcutils.hpp>
// #include <qlib/Vector4D.hpp>

#include <qsys/DispListRenderer.hpp>
#include <gfx/SolidColor.hpp>

#include "MolSurfObj.hpp"

#include <modules/molstr/molstr.hpp>
#include <modules/molstr/ColoringScheme.hpp>

namespace qsys { class ScalarObject; }
namespace molstr {
  class MolCoord;
  class AtomPosMap;
}

namespace surface {

using qlib::Vector4D;
using gfx::ColorPtr;
using gfx::DisplayContext;
using molstr::MolCoordPtr;
using molstr::AtomPosMap;

class MolSurfRenderer : public qsys::DispListRenderer, public molstr::ColSchmHolder
{
  MC_SCRIPTABLE;
  MC_CLONEABLE;

  typedef qsys::DispListRenderer super_t;

private:

  /// cull face
  bool m_bCullFace;

  /// wireframe model
  bool m_bWireFrame;

  /// dot surface
  bool m_bDotSurf;

  /// coloring mode
  int m_nMode;
  
  /// molecule object name by which painting color is determined.
  /// (used in MOLFANC mode)
  LString m_sTgtObj;

  /// potentialmap object name by which painting color is determined.
  /// (used in ELEPOT mode)
  LString m_sTgtElePot;

  /// moelcular selection (used in MOLFANC mode)
  molstr::SelectionPtr m_pMolSel;

  /// Color params in potential mode
  double m_dParLow;

  double m_dParMid;

  double m_dParHigh;

  ColorPtr m_colHigh;

  ColorPtr m_colMid;

  ColorPtr m_colLow;

  /// Ramp_above mode
  bool m_bRampAbove;

  /////////////
  // work area
  qsys::ScalarObject *m_pScaObj;

  MolCoordPtr m_pMol;
  AtomPosMap *m_pAmap;

  /// target surface object
  MolSurfObj *m_pSurf;

public:
  enum {
    SFREND_SIMPLE = 0,
    SFREND_SCAPOT = 1,
    SFREND_MOLSIMP = 2,
    SFREND_MOLFANC = 3,
  };

public:

  ///////////////////////////////////////////
  // constructors / destructor

  /** default constructor */
  MolSurfRenderer();

  /** destructor */
  virtual ~MolSurfRenderer();

  //////////////////////////////////////////////////////
  // Renderer implementation
  
  virtual bool isCompatibleObj(qsys::ObjectPtr pobj) const;
  
  virtual LString toString() const;

  ///////////////////////////////////////////

  virtual const char *getTypeName() const;

  // virtual void attachObj(qlib::uid_t obj_uid);
  // virtual qlib::uid_t detachObj();

  virtual Vector4D getCenter() const;

  ///////////////////////////////////////////
  // DispListRenderer implemention

  virtual void render(DisplayContext *pdl);
  virtual void preRender(DisplayContext *pdc) {}
  virtual void postRender(DisplayContext *pdc) {}


  // virtual void targetChanged(MbObjEvent &ev);

  ///////////////////////////////////////////

  void render_dot(DisplayContext *pdl);

  void setDefaultColor(const ColorPtr &rc) {
    ColSchmHolder::setDefaultColor(rc);
    invalidateDisplayCache();
  }
  
  bool isCullFace() const { return m_bCullFace; }
  void setCullFace(bool b) {
    m_bCullFace = b;
    invalidateDisplayCache();
  }

  bool isWireFrame() const { return m_bWireFrame; }
  void setWireFrame(bool b) {
    m_bWireFrame = b;
    invalidateDisplayCache();
  }

  bool isDotSurf() const { return m_bDotSurf; }
  void setDotSurf(bool b) {
    m_bDotSurf = b;
    invalidateDisplayCache();
  }

  int getColorMode() const { return m_nMode; }
  void setColorMode(int n) {
    m_nMode = n;
    invalidateDisplayCache();
  }

  /// reference molecule target (used in molecule mode)
  LString getTgtObjName() const { return m_sTgtObj; }
  void setTgtObjName(const LString &n) {
    m_sTgtObj = n;
    invalidateDisplayCache();
  }

  //////////
  // for "potential" mode

  /// reference elepot target (used in potential mode)
  LString getTgtElePotName() const { return m_sTgtElePot; }
  void setTgtElePotName(const LString &n) {
    m_sTgtElePot = n;
    invalidateDisplayCache();
  }

  double getLowPar() const { return m_dParLow; }
  void setLowPar(double d) {
    m_dParLow = d;
    if (m_nMode==SFREND_SCAPOT)
      invalidateDisplayCache();
  }

  double getMidPar() const { return m_dParMid; }
  void setMidPar(double d) {
    m_dParMid = d;
    if (m_nMode==SFREND_SCAPOT)
      invalidateDisplayCache();
  }

  double getHighPar() const { return m_dParHigh; }
  void setHighPar(double d) {
    m_dParHigh = d;
    if (m_nMode==SFREND_SCAPOT)
      invalidateDisplayCache();
  }

  ColorPtr getLowCol() const { return m_colLow; }
  void setLowCol(const ColorPtr &rc) {
    m_colLow = rc;
    if (m_nMode==SFREND_SCAPOT)
      invalidateDisplayCache();
  }

  ColorPtr getHighCol() const { return m_colHigh; }
  void setHighCol(const ColorPtr &rc) {
    m_colHigh = rc;
    if (m_nMode==SFREND_SCAPOT)
      invalidateDisplayCache();
  }

  ColorPtr getMidCol() const { return m_colMid; }
  void setMidCol(const ColorPtr &rc) {
    m_colMid = rc;
    if (m_nMode==SFREND_SCAPOT)
      invalidateDisplayCache();
  }

  bool isRampAbove() const { return m_bRampAbove; }
  void setRampAbove(bool val) {
    m_bRampAbove = val;
    if (m_nMode==SFREND_SCAPOT)
      invalidateDisplayCache();
  }

  ////

  molstr::SelectionPtr getMolSel() const {
    return m_pMolSel;
  }

  void setMolSel(molstr::SelectionPtr pNewSel) {
    m_pMolSel = pNewSel;
    makeAtomPosMap();
  }

  void makeAtomPosMap();
  

  ////

  virtual void propChanged(qlib::LPropEvent &ev);
  
private:

  bool getColorSca(float x, float y, float z, ColorPtr &rcol);
  bool getColorMol(float x, float y, float z, ColorPtr &rcol);
};

}

#endif

