// -*-Mode: C++;-*-
//
//  molecular surface builder
//
// $Id: MolSurfBuilder.cpp,v 1.2 2011/02/11 06:54:22 rishitani Exp $

#include <common.h>
#include "surface.hpp"

#ifdef SURF_BUILDER_TEST

#include "MolSurfBuilder.hpp"
#include "RSCompBuilder.hpp"
#include "SESTgBuilder.hpp"

#include <modules/molstr/MolCoord.hpp>
#include <modules/molstr/MolAtom.hpp>
#include <modules/molstr/AtomIterator.hpp>

#include <gfx/DisplayContext.hpp>

using namespace surface;
using gfx::DisplayContext;
using molstr::MolAtomPtr;
using molstr::AtomIterator;

MolSurfBuilder::~MolSurfBuilder()
{
/*  RSEdgeList::iterator iter = m_edges.begin();
  for (; iter!=m_edges.end(); ++iter)
    delete *iter;
  
  RSFaceList::iterator fiter = m_faces.begin();
  for (; fiter!=m_faces.end(); ++fiter)
    delete *fiter;
	*/
}

bool MolSurfBuilder::init(MolCoordPtr pmol)
{
  AtomIterator aiter(pmol);
  int i, natoms=0;

  // count atom number
  for (aiter.first(); aiter.hasMore(); aiter.next()) {
    MolAtomPtr pAtom = aiter.get();
    MB_ASSERT(!pAtom.isnull());
    ++natoms;
  }

  // copy to the m_data
  m_data.resize(natoms);
  m_tree.alloc(natoms);
  for (i=0,aiter.first(); aiter.hasMore()&&i<natoms; aiter.next(),++i) {
    MolAtomPtr pAtom = aiter.get();
    m_data[i].pos = pAtom->getPos();
    m_data[i].rad = 1.5;
    m_data[i].aid = pAtom->getID();

    m_tree.setAt(i, m_data[i].pos, i);
  }

  // build BSP tree
  m_tree.build();

  m_rmax = 1.5;
  m_rprobe = 1.2;
  return true;
}

void MolSurfBuilder::build()
{
  RSCompBuilder rscb(this);
  rscb.build();

  SESTgBuilder tgb(this, &(rscb.m_rscomp));
  tgb.build();
}

void SurfTgSet::draw(DisplayContext *pdl)
{
  pdl->startTriangles();
  std::deque<MSFace>::const_iterator iter =  m_faces.begin();
  for ( ; iter!=m_faces.end(); ++iter) {
    const MSFace &f = *iter;
    const MSVert &v1 = m_verteces[f.id1];
    const MSVert &v2 = m_verteces[f.id2];
    const MSVert &v3 = m_verteces[f.id3];

    pdl->normal(v1.n3d());
    pdl->vertex(v1.v3d());

    pdl->normal(v2.n3d());
    pdl->vertex(v2.v3d());

    pdl->normal(v3.n3d());
    pdl->vertex(v3.v3d());
  }
  pdl->end();
}

void SurfTgSet::drawIndex(DisplayContext *pdl, int iv, int ishow)
{
  LString msg = LString::format("%d", ishow);
  const MSVert &v1 = m_verteces[iv];

  pdl->setLighting(false);
  pdl->drawString(v1.v3d(), msg);
  pdl->setLighting(true);
}

//////////////////////////////////////////////////////////////////////////

void MolSurfBuilder::drawDisk(const Vector4D &cen, const Vector4D &norm, double rad)
{
  const double thik = 0.05;
  const Vector4D start = cen - norm.scale(thik/2.0);
  const Vector4D end   = cen + norm.scale(thik/2.0);
  m_pdl->cylinderCap(rad, start, end);
}

void MolSurfBuilder::drawArc(const Vector4D &n, double rad, const Vector4D &cen,
             const Vector4D &vst, double theta2)
{
  const Vector4D &e1 = n;
  const Vector4D e2 = vst.normalize();
  const Vector4D e3 = e1.cross(e2);

  Matrix4D xfmat = Matrix4D::makeTransMat(cen);

  xfmat.aij(1,1) = e2.x();
  xfmat.aij(2,1) = e2.y();
  xfmat.aij(3,1) = e2.z();

  xfmat.aij(1,2) = e3.x();
  xfmat.aij(2,2) = e3.y();
  xfmat.aij(3,2) = e3.z();

  xfmat.aij(1,3) = e1.x();
  xfmat.aij(2,3) = e1.y();
  xfmat.aij(3,3) = e1.z();

  m_pdl->pushMatrix();
  m_pdl->multMatrix(xfmat);
  /*m_pdl->cylinder(0.05, Vector4D(0,0,0), e1);
    m_pdl->cylinder(0.05, Vector4D(0,0,0), e2);
    m_pdl->cylinder(0.05, Vector4D(0,0,0), e3);*/

  /*
    m_pdl->color_3d(1, 0, 0);
    m_pdl->cylinder(0.05, Vector4D(0,0,0), Vector4D(1,0,0));
    m_pdl->color_3d(0, 1, 0);
    m_pdl->cylinder(0.05, Vector4D(0,0,0), Vector4D(0,1,0));
    m_pdl->color_3d(0, 0, 1);
    m_pdl->cylinder(0.05, Vector4D(0,0,0), Vector4D(0,0,1));
   */

  const double arclen = qlib::abs(theta2 * rad);
  int ndiv = int(arclen/0.1);
  if (ndiv<5)
    ndiv = 5;
  const double dth = theta2/double(ndiv);
  //MB_DPRINTLN("arclen: %f, ndiv: %d, dth: %f", arclen, ndiv, dth);

  int i;
  double th = 0.0;
  m_pdl->setLighting(false);
  m_pdl->startLineStrip();
  for (i=0; i<ndiv+1; ++i) {
    m_pdl->vertex(rad*::cos(th), rad*::sin(th), 0.0);
    th += dth;
  }
  m_pdl->end();
  m_pdl->setLighting(true);
  m_pdl->popMatrix();
}

#endif // SURF_BUILDER_TEST

