// -*-Mode: C++;-*-
//
//  molecular surface builder
//
// $Id: MS2TestRenderer.cpp,v 1.1 2011/02/11 06:54:22 rishitani Exp $

#include <common.h>

#include "MS2TestRenderer.hpp"
#include <gfx/DisplayContext.hpp>

#ifdef SURF_BUILDER_TEST
#include "MolSurfBuilder.hpp"
#include "RSCompBuilder.hpp"
#endif

using namespace surface;
using gfx::DisplayContext;

MS2TestRenderer::MS2TestRenderer()
{
}

MS2TestRenderer::~MS2TestRenderer()
{
}

const char *MS2TestRenderer::getTypeName() const
{
  return "ms2test";
}

void MS2TestRenderer::render(DisplayContext *pdl)
{
#ifdef SURF_BUILDER_TEST
  MolCoordPtr pmol = getClientMol();

  MolSurfBuilder msb;
  msb.init(pmol);

  pdl->setLighting(true);
  int nDetailOld = pdl->getDetail();
  pdl->setDetail(10);

  msb.setDC(pdl);
  msb.build();

  pdl->setDetail(nDetailOld);
  pdl->setLighting(false);
#endif
}

void MS2TestRenderer::preRender(DisplayContext *pdc)
{
}

void MS2TestRenderer::postRender(DisplayContext *pdc)
{
}

qlib::Vector4D MS2TestRenderer::getCenter() const
{
  return Vector4D();
}

// Hittest implementation
bool MS2TestRenderer::isHitTestSupported() const
{
  return false;
}

void MS2TestRenderer::renderHit(DisplayContext *phl)
{
}

