// -*-Mode: C++;-*-
//
//  Nucleic acid renderer class
//
//  $Id: NARenderer.cpp,v 1.4 2011/01/31 04:43:49 rishitani Exp $

#include <common.h>

#include "NARenderer.hpp"

#include <modules/molstr/MolCoord.hpp>
#include <modules/molstr/MolChain.hpp>
#include <modules/molstr/MolResidue.hpp>
#include <modules/molstr/MolAtom.hpp>

//#include <qlib/LChar.hpp>
//#include <gfx/DisplayCommand.hpp>
//#include <molstr/MolAtom.hpp>

using namespace molvis;
using namespace molstr;

NARenderer::NARenderer()
     : TubeRenderer()
{
  //, m_bondw(0.5), m_nType(NAREND_BP), m_fRendTube(true)
  //TubeRenderer::setPivAtomName("c4'");
  //TubeRenderer::setPivAtomName("p");
  //TubeRenderer::setWidth(0.5);
  //TubeRenderer::setTuber(2.5);
  //m_bondcol = LColor(255,255,0);

  m_pBpTmp = NULL;
  m_bondw = 0.5;
  m_nType = 0;
  m_fRendTube = true;
  m_nBaseDetail = 3;

  //resetAllProps();
}

NARenderer::~NARenderer()
{
}

const char *NARenderer::getTypeName() const
{
  return "nucl";
}

//////////////////////////////////////////////////////

void NARenderer::beginRend(DisplayContext *pdl)
{
  if (m_pBpTmp!=NULL)
    delete m_pBpTmp;
  m_pBpTmp = new std::set<MolResidue *>;
  pdl->setDetail(m_nBaseDetail);

  TubeRenderer::beginRend(pdl);
}

void NARenderer::endRend(DisplayContext *pdl)
{
  if (m_pBpTmp!=NULL)
    delete m_pBpTmp;
  m_pBpTmp = NULL;

  TubeRenderer::endRend(pdl);
}

void NARenderer::beginSegment(DisplayContext *pdl, MolResiduePtr pRes)
{
  if (m_fRendTube)
    TubeRenderer::beginSegment(pdl, pRes);
}

void NARenderer::rendResid(DisplayContext *pdl, MolResiduePtr pRes)
{
  switch (m_nType) {
  default:
  case NAREND_BP:
    rendResidBasePair(pdl, pRes);
    break;

  case NAREND_SIMPLE1:
    rendResidSimple1(pdl, pRes);
    break;

  }
  
  if (m_fRendTube)
    TubeRenderer::rendResid(pdl, pRes);
}

void NARenderer::endSegment(DisplayContext *pdl, MolResiduePtr pRes)
{
  if (m_fRendTube)
    TubeRenderer::endSegment(pdl, pRes);
}

//////////////////////////////////////////////////////

void NARenderer::rendResidBasePair(DisplayContext *pdl, MolResiduePtr pRes)
{
  if (m_pBpTmp->find(pRes.get())!=m_pBpTmp->end())
    return; // already rendered!!
  /*{
    LOG_DPRINTLN("%s.%d", (const char *)pRes->getChainName(), pRes->getIndex());
    std::set<MolResiduePtr >::const_iterator iter = m_pBpTmp->begin();
    for ( ; iter!=m_pBpTmp->end(); iter++) {
      MolResiduePtr p = *iter;
      LOG_DPRINTLN(">  %s.%d", (const char *)p->getChainName(), p->getIndex());
    }
  }*/

  LString btype;
  pRes->getPropStr("basetype", btype);

  LString bpair;
  pRes->getPropStr("basepair", bpair);

  if (bpair.isEmpty()) {
    MolAtomPtr pA1, pA3;
    if (btype.equals("pur")) {
      //pA1 = pRes->getAtom("C4'");
      pA1 = getPivotAtom(pRes);
      pA3 = pRes->getAtom("N1");
    }
    else if (btype.equals("pyr")) {
      //pA1 = pRes->getAtom("C4'");
      pA1 = getPivotAtom(pRes);
      pA3 = pRes->getAtom("N3");
    }
    
    if (!pA1.isnull() && !pA3.isnull()) {
      //ColorPtr col = ColSchmHolder::getColor(pRes);
      // Get the pivot atom's color --> pA1 is pivot atom
      ColorPtr col = ColSchmHolder::getColor(pA1);
      pdl->setLighting(true);
      pdl->color(col);
      pdl->cylinder(m_bondw, pA1->getPos(), pA3->getPos());
      pdl->sphere(m_bondw, pA3->getPos());
      pdl->setLighting(false);
    }
  }
  else {
    MolCoordPtr pMol = pRes->getParent();
    int dotpos = bpair.indexOf('.');
    LString chname = bpair.left(dotpos);
    // chname = chname.toLowerCase();
    LString resids = bpair.mid(dotpos+1);
    MolChainPtr pCh = pMol->getChain(chname);
    if (pCh.isnull())
      return;
    
    int nresid;
    if (!resids.toInt(&nresid))
      return;
    MolResiduePtr pPeer = pCh->getResidue(nresid);
    if (pPeer.isnull())
      return;

    MolAtomPtr pA1, pA3;
    pA1 = getPivotAtom(pRes);
    pA3 = getPivotAtom(pPeer);
    if (!pA1.isnull() && !pA3.isnull()) {
      //ColorPtr col = ColSchmHolder::getColor(pRes);
      // Get the pivot atom's color --> pA1 is pivot atom
      ColorPtr col = ColSchmHolder::getColor(pA1);
      pdl->setLighting(true);
      pdl->color(col);
      pdl->cylinder(m_bondw, pA1->getPos(), pA3->getPos());
      pdl->setLighting(false);
    }
    m_pBpTmp->insert(pPeer.get());
  }
}

void NARenderer::rendResidSimple1(DisplayContext *pdl, MolResiduePtr pRes)
{
  LString btype;
  pRes->getPropStr("basetype", btype);

  MolAtomPtr pA1, pA2, pA3;
  if (btype.equals("pur")) {
    //pA1 = pRes->getAtom("C4'");
    pA1 = getPivotAtom(pRes);
    pA2 = pRes->getAtom("N9");
    pA3 = pRes->getAtom("N1");
  }
  else if (btype.equals("pyr")) {
    //pA1 = pRes->getAtom("c4'");
    pA1 = getPivotAtom(pRes);
    pA2 = pRes->getAtom("N1");
    pA3 = pRes->getAtom("N3");
  }
  
  if (!pA1.isnull() && !pA2.isnull() && !pA3.isnull()) {
    // Get the pivot atom's color --> pA1 is pivot atom
    //ColorPtr col = ColSchmHolder::getColor(pRes);
    ColorPtr col = ColSchmHolder::getColor(pA1);
    pdl->setLighting(true);
    pdl->color(col);
    pdl->cylinder(m_bondw, pA1->getPos(), pA2->getPos());
    pdl->cylinder(m_bondw, pA2->getPos(), pA3->getPos());
    pdl->sphere(m_bondw, pA1->getPos());
    pdl->sphere(m_bondw, pA2->getPos());
    pdl->sphere(m_bondw, pA3->getPos());
    pdl->setLighting(false);
  }
}



