// -*-Mode: C++;-*-
//
//  Abstract/Solid coloring classes
//
//  $Id: ColoringScheme.cpp,v 1.2 2011/03/30 14:17:36 rishitani Exp $

#include <common.h>

#include "ColoringScheme.hpp"
#include "MolAtom.hpp"
#include "MolResidue.hpp"

#include <gfx/DisplayContext.hpp>
#include <gfx/SolidColor.hpp>

using namespace molstr;

/////////////////////////////////////////////////////////////////////////////

ColoringScheme::~ColoringScheme()
{
  MB_DPRINTLN("Destroy ColoringScheme(%p)", this);
}

bool ColoringScheme::init(MolCoordPtr,Renderer*)
{
  return true;
}

bool ColoringScheme::getResidColor(MolResiduePtr pResid, ColorPtr &color)
{
  MolAtomPtr pA = pResid->getPivotAtom();
  if (pA.isnull()) return false;
  return getAtomColor(pA, color);
}

ColoringSchemePtr ColoringScheme::createDefaultS()
{
  return ColoringSchemePtr(new SolidColoring);
}

//////////

SolidColoring::~SolidColoring()
{
}

bool SolidColoring::getAtomColor(MolAtomPtr pAtom, ColorPtr &pcol)
{
  return false;
}

qlib::LCloneableObject *SolidColoring::clone() const
{
  return new SolidColoring(*this);
}

