// -*-Mode: C++;-*-
//
// Pixel buffer object
//

#ifndef GFX_PIXEL_BUFFER_HPP_INCLUDED_
#define GFX_PIXEL_BUFFER_HPP_INCLUDED_

#include "gfx.hpp"

#include <qlib/LString.hpp>

namespace gfx {

using qlib::LString;

class PixelBuffer : public std::vector<QUE_BYTE>
{
private:
  int m_nWidth;
  int m_nHeight;
  int m_nDepth;
  typedef std::vector<QUE_BYTE> super_t;

public:
  PixelBuffer() : super_t(), m_nWidth(0), m_nHeight(0), m_nDepth(8) {}
  PixelBuffer(const PixelBuffer &src)
       : super_t(src), m_nWidth(src.m_nWidth), m_nHeight(src.m_nHeight), m_nDepth(src.m_nDepth)
    {
    }
  ~PixelBuffer() {}

  int getWidth() const { return m_nWidth; }
  int getHeight() const { return m_nHeight; }
  int getDepth() const { return m_nDepth; }

  void setHeight(int aValue) { m_nHeight = aValue; }
  void setWidth(int aValue) { m_nWidth = aValue; }
  void setDepth(int aValue) { m_nDepth = aValue; }

  QUE_BYTE *data() { return &(super_t::operator[](0)); }
  const QUE_BYTE *data() const { return &(super_t::operator[](0)); }
};

}

#endif
