// -*-Mode: C++;-*-
//
//  Gradient color class
//
// $Id: GradientColor.cpp,v 1.2 2009/12/10 14:09:59 rishitani Exp $

#include <common.h>

#include "GradientColor.hpp"
#include <qlib/Utils.hpp>
#include <qlib/Vector4D.hpp>

using namespace gfx;

MC_CLONEABLE_IMPL(gfx::GradientColor);

GradientColor::GradientColor()
{
}

GradientColor::GradientColor(const GradientColor &r)
{
  m_pColor1 = r.m_pColor1;
  m_pColor2 = r.m_pColor2;
  m_rho = r.m_rho;
}

GradientColor::GradientColor(ColorPtr pc1, ColorPtr pc2, double par)
{
  m_pColor1 = pc1;
  m_pColor2 = pc2;
  m_rho = par;
}

GradientColor::~GradientColor()
{
}

const GradientColor &GradientColor::operator=(const GradientColor &r)
{
  if(&r!=this){
    m_pColor1 = r.m_pColor1;
    m_pColor2 = r.m_pColor2;
    m_rho = r.m_rho;
  }
  return *this;
}

///////////////////////////
// AbstractColor implementations

int GradientColor::r() const
{
  if (m_pColor1.isnull()||m_pColor2.isnull()) {
    MB_THROW(qlib::NullPointerException, "GradientColor is not initialized");
  }
  double r = (double(m_pColor1->r())*m_rho +
              double(m_pColor2->r())*(1.0-m_rho));
  return (int)r;
}

int GradientColor::g() const
{
  if (m_pColor1.isnull()||m_pColor2.isnull()) {
    MB_THROW(qlib::NullPointerException, "GradientColor is not initialized");
  }
  double r = (double(m_pColor1->g())*m_rho +
              double(m_pColor2->g())*(1.0-m_rho));
  return (int)r;
}

int GradientColor::b() const
{
  if (m_pColor1.isnull()||m_pColor2.isnull()) {
    MB_THROW(qlib::NullPointerException, "GradientColor is not initialized");
  }
  double r = (double(m_pColor1->b())*m_rho +
              double(m_pColor2->b())*(1.0-m_rho));
  return (int)r;
}

int GradientColor::a() const
{
  if (m_pColor1.isnull()||m_pColor2.isnull()) {
    MB_THROW(qlib::NullPointerException, "GradientColor is not initialized");
  }
  double r = (double(m_pColor1->a())*m_rho +
              double(m_pColor2->a())*(1.0-m_rho));
  return (int)r;
}

unsigned int GradientColor::getCode() const
{
  return AbstractColor::makeRGBACode(r(), g(), b(), a());
}

LString GradientColor::getMaterial() const
{
  return m_pColor1->getMaterial();
}
    
bool GradientColor::equals(const AbstractColor &c) const
{
  return GradientColor::getCode()==c.getCode();
}

    
////////////
// Simple copy obj implementation

bool GradientColor::isStrConv() const
{
  return false;
}

LString GradientColor::toString() const
{
  return LString();
}

