// -*-Mode: C++;-*-
//
//  Abstract display context class
//
// $Id: DisplayContext.cpp,v 1.7 2011/02/11 06:56:57 rishitani Exp $

#include <common.h>

#include "DisplayContext.hpp"
#include "SolidColor.hpp"

using namespace gfx;

void DisplayContext::vertex(const Vector4D &vec)
{
  vertex(vec.x(), vec.y(), vec.z());
}

void DisplayContext::normal(const Vector4D &vec)
{
  normal(vec.x(), vec.y(), vec.z());
}

void DisplayContext::rotate(const qlib::LQuat &q)
{
  multMatrix(q.toRotMatrix());
}

void DisplayContext::color(double r, double g, double b, double a)
{
  color(SolidColor::createRGB(r,g,b,a));
}

void DisplayContext::color(double r, double g, double b)
{
  color(SolidColor::createRGB(r,g,b));
}

void DisplayContext::setMaterial(const LString &name)
{
  m_defMatName = name;
}

void DisplayContext::setAlpha(double a)
{
  m_defAlpha = a;
}

void DisplayContext::scale(const Vector4D &v)
{
  Matrix4D m;
  m.aij(1,1) = v.x();
  m.aij(2,2) = v.y();
  m.aij(3,3) = v.z();
  m.aij(4,4) = 1.0;
  multMatrix(m);
}

void DisplayContext::translate(const Vector4D &v)
{
	Matrix4D m = Matrix4D::makeTransMat(v);
//  m.aij(4,4) = 1.0;
  multMatrix(m);
}

void DisplayContext::loadIdent()
{
  Matrix4D m;
  loadMatrix(m);
}

void DisplayContext::drawString(const Vector4D &pos,
                                const qlib::LString &str)
{
}

void DisplayContext::drawPixels(const Vector4D &pos,
                                const gfx::PixelBuffer &data,
                                const AbstractColor &col)
{
}

void DisplayContext::cylinder(double r, const Vector4D &pos1, const Vector4D &pos2)
{
  cone(r, r, pos1, pos2, false);
}

void DisplayContext::cylinderCap(double r, const Vector4D &pos1, const Vector4D &pos2)
{
  cone(r, r, pos1, pos2, true);
}

void DisplayContext::cone(double r1, double r2,
                          const Vector4D &pos1, const Vector4D &pos2,bool bCap)
{
  return;
}

void DisplayContext::drawMesh(const Mesh &)
{
}

