package yukihane.jnicoapi;

import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author yuki
 */
public class NamePattern {

    private static final String titlePattern = "{title}";
    private static final String idPattern = "{id}";
    private static final String lowPattern = "{low}";
    private static Logger log = LoggerFactory.getLogger(NamePattern.class);
    private final String pattern;
    private String id = "";
    private String title = "";
    private boolean isNotLow = true;

    public NamePattern(String pattern) {
        this.pattern = pattern;
    }

    /**
     * 保存ファイル名の命名規則.
     *
     * @param pattern 命名パターン.
     * @param replaceFrom 禁則文字を指定する.
     * @param replaceTo 禁則文字をこの文字列に置換する.
     * @param title ファイル名に用いるタイトル文字列.
     */
    public NamePattern(String pattern, String title) {
        this.pattern = pattern;
        this.title = title;
    }

    public final String createFileName() {
        String res = replacePlaceHolder(pattern);
        return replaceIllegalChar(res);
    }

    public final String createFileName(String id, boolean isNotLow) {
        this.id = id;
        this.isNotLow = isNotLow;

        return createFileName();
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setIsNotLow(boolean isNotLow) {
        this.isNotLow = isNotLow;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    protected String replacePlaceHolder(String str) {
        String res = str.replace(titlePattern, title);
        res = res.replace(idPattern, id);
        String low = isNotLow ? "" : "low";
        res = res.replace(lowPattern, low);
        return res;
    }

    private String replaceIllegalChar(String res) {
//        // TODO 正規表現で書き直す
//        char[] replaceds = new char[replaceFrom.length()];
//        replaceFrom.getChars(0, replaceFrom.length(), replaceds, 0);
//        StringBuilder str = new StringBuilder();
//        for (int i = 0; i < res.length(); i++) {
//            char c = res.charAt(i);
//            String moji = String.valueOf(c);
//            for (char replaced : replaceds) {
//                if (c == replaced) {
//                    moji = replaceTo;
//                }
//            }
//            str.append(moji);
//        }
//        return getSanitizedDescription(str.toString());
        return getSanitizedDescription(res);
    }

    public static String getSanitizedDescription(String decodedDesc) {
        String fileNameCharset = System.getProperty("fileNameCharset", "");

        String narrowedDesc = narrowCharset(decodedDesc, fileNameCharset);

        // 実体参照を更に実体参照するケースがあるので二回置換する
        narrowedDesc = replaceER(replaceER(narrowedDesc));

        char descArray[] = narrowedDesc.toCharArray();

        for (int i = 0; i < descArray.length; i++) {
            char c = descArray[i];
            switch (c) {
                case '\\':
                case '\u00a5':
                    c = '￥';
                    break;
                case '/':
                    c = '／';
                    break;
                case ':':
                    c = '：';
                    break;
                case '*':
                    c = '＊';
                    break;
                case '?':
                    c = '？';
                    break;
                case '"':
                    c = '”';
                    break;
                case '<':
                    c = '＜';
                    break;
                case '>':
                    c = '＞';
                    break;
                case '|':
                    c = '｜';
                    break;
                case '\u203e':// c = '~'; break;
                case '\u301c':// c = '～'; break;
                case '\u2016':
                case '\u2212':
                case '\u00a2':
                case '\u00a3':
                case '\u00ac':
                    c = '-';
                    break;
            }

            descArray[i] = c;
        }
        return new String(descArray);
    }

    private static String replaceER(String src) {
        return src.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").
                replaceAll("&apos;", "'");
    }

    // 一旦目的の文字コードにしてから戻して、対応してない文字を '?' にする
    static String narrowCharset(String str, String charsetName) {
        String narrowedDesc = str;
        if (!charsetName.equals("")) {
            try {
                narrowedDesc =
                        new String(str.getBytes(charsetName), charsetName);
                // characters which are not supported by the charset
                // become '?'
            } catch (UnsupportedEncodingException e) {
                log.warn(e.toString());
            }
        }
        return narrowedDesc;
    }
}
