package yukihane.inqubus.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

/**
 *
 * @author yuki
 */
public class FileChooseActionListener implements ActionListener {

    private final Component parent;
    private final int fileSelectionMode;
    private final JTextField textField;

    public FileChooseActionListener(Component parent, int fileSelectionMode, JTextField field) {
        this.parent = parent;
        this.fileSelectionMode = fileSelectionMode;
        this.textField = field;
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        final JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(fileSelectionMode);
        fc.setCurrentDirectory(new File(textField.getText()));
        final int res = fc.showOpenDialog(parent);
        if (res == JFileChooser.APPROVE_OPTION) {
            textField.setText(fc.getSelectedFile().getPath());
        }
    }
}
