<?php
/**
 * 縦書きのために文字を変換します。
 * 
 * @param string $buff
 * @return string
 */
function pripre_tate_filter($buff) {
	mb_regex_encoding('UTF-8');
    mb_internal_encoding("UTF-8");

    $nums = "0123456789";
    $from = "0123456789０１２３４５６７８９“”．－―";
    $to = "０１２３４５６７８９〇一二三四五六七八九〝〟・―─";

    $textarr = explode("\n", $buff);
    foreach($textarr as &$buff) {
    $result = '';
    $state = 0;
    for ($i = 0; $i < mb_strlen($buff); ++$i) {
        $c = mb_substr($buff, $i, 1);
        if (mb_strpos($nums, $c) !== FALSE) {
            if ($state == 0) {
                $state = 2;
                $pos = $i;
                continue;
            } else if ($state == 3) {
                
            } else if ($i - $pos >= 2) {
                $i = $pos - 1;
                $state = 3;
                continue;
            } else {
                continue;
            }
        } else {
            if ($state == 2) {
                if ($i - $pos >= 2) {
                    $result = $result.'<span class="_tcy">';
                    $result = $result.mb_substr($buff, $pos, $i - $pos);
                    $result = $result.'</span>';
                } else {
                    $i = $pos - 1;
                    $state = 3;
                    continue;
                }
            }
            $state = 0;
        }
        if ($c == '<') {
            if (mb_substr($buff, $i + 1, 18) == 'span class="_pre">') {
                for (; $i < mb_strlen($buff); ++$i) {
                    $c = mb_substr($buff, $i, 1);
                    $result = $result.$c;
                    if ($c == '<' && mb_substr($buff, $i + 1, 5) == '/span') {
                        break;
                    }
                }
                continue;
            }
            for (; $i < mb_strlen($buff); ++$i) {
                $c = mb_substr($buff, $i, 1);
                $result = $result.$c;
                if ($c == '>') {
                    break;
                }
            }
            continue;
        }
        else if ($c == 'h' && mb_substr($buff, $i + 1, 4) == 'ttp:') {
            for (; $i < mb_strlen($buff); ++$i) {
                $c = mb_substr($buff, $i, 1);
                if (mb_strpos('!#$%&*+-./0123456789:;=?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_abcdefghijklmnopqrstuvwxyz[|]~', $c) === FALSE) {
                    break;
                }
                $result = $result.$c;
            }
        }

        $ix = mb_strpos($from, $c);
        if ($ix !== FALSE) {
            $c = mb_substr($to, $ix, 1);
        }
        $result = $result.$c;
    }
    $buff = $result;
    }
    return implode("\n", $textarr);
}

define("PRIPRE_RB", "<ruby>");
define("PRIPRE_RTB", "<rp>（</rp><rt>");
define("PRIPRE_RTE", "</rt><rp>）</rp></ruby>");

function pripre_is_kanji($c) {
	return preg_match("/^[一-龠]+$/u", $c) || $c == '々';
}

function pripre_substr_replace(&$buff, $replace, $start, $len) {
	$buff = mb_substr($buff, 0, $start) . $replace . mb_substr($buff, $start + $len);
}

/**
 * ルビ、圏点などの処理をします。
 * 
 * @param string $buff
 * @return string
 */
function pripre_text_filter($buff) {
    mb_regex_encoding('UTF-8');
    mb_internal_encoding("UTF-8");

    $textarr = explode("\n", $buff);
    foreach($textarr as &$buff) {
    for ($i = 0; $i < mb_strlen($buff); ++$i) {
        $c = mb_substr($buff, $i, 1);

        if ($c == '《') {
            // ルビ
            $j = $i + 1;
            $blen = mb_strlen($buff);
            for (; $j < $blen; ++$j) {
                $d = mb_substr($buff, $j, 1);
                if ($d == '》') {
                    break;
                }
            }
            if ($j == $blen) {
                continue;
            }
            $scan_kanji = TRUE;
            $k = $i;
            for (; $k > 0; --$k) {
                $d = mb_substr($buff, $k - 1, 1);
                if ($d == '｜') {
                    pripre_substr_replace($buff, "", $k - 1, 1);
                    --$k;
                    --$j;
                    --$i;
                    break;
                }
                if ($scan_kanji
                        && (!pripre_is_kanji($d) || $d == '》')) {
                    if ($k == $i) {
                        $scan_kanji = FALSE;
                    } else {
                        break;
                    }
                }
            }
            if ($i == $k) {
                continue;
            }
            pripre_substr_replace($buff, "", $i, 1);
            --$j;
            pripre_substr_replace($buff, "", $j, 1);
            pripre_substr_replace($buff, PRIPRE_RB, $k, 0);
            $i += mb_strlen(PRIPRE_RB);
            $j += mb_strlen(PRIPRE_RB);
            pripre_substr_replace($buff, PRIPRE_RTB, $i, 0);
            $j += mb_strlen(PRIPRE_RTB);
            $i = $j;
            pripre_substr_replace($buff, PRIPRE_RTE, $i, 0);
            $i += mb_strlen(PRIPRE_RTE);
        } else if ($c == '［') {
            $blen = mb_strlen($buff);
            $j = $i + 1;
            $d = mb_substr($buff, $j, 1);
            if ($d != '＃') {
                continue;
            }

            for (; $j < $blen; ++$j) {
                $d = mb_substr($buff, $j, 1);
                if ($d == '］') {
                    break;
                }
            }
            if ($j == $blen) {
                continue;
            }
            $scan_kanji = TRUE;
            $k = $i;
            for (; $k > 0; --$k) {
                $d = mb_substr($buff, $k - 1, 1);
                if ($d == '｜') {
                    pripre_substr_replace($buff, "", $k - 1, 1);
                    --$k;
                    --$j;
                    --$i;
                    break;
                }
                if ($scan_kanji
                        && (!pripre_is_kanji($d) || $d == '》')) {
                    if ($k == $i) {
                        $scan_kanji = FALSE;
                    } else {
                        break;
                    }
                }
            }
            if ($i == $k) {
                continue;
            }
            $op = mb_substr($buff, $i + 2, 2);
            switch($op) {
	            case "圏点":
	           	if (mb_substr($buff, $i + 4, 1) == '］') {
	           		$emStart = "<span class=\"_em\">";
	           	}
	           	else {
	            	$emStart = "<span style=\"-epub-text-emphasis:'".
	            		mb_substr($buff, $i + 5, $j - ($i + 5))."'\">";
	           	}
	            $emEnd = "</span>";
	            pripre_substr_replace($buff, $emEnd, $i, ($j + 1) - $i);
	            $i += mb_strlen($emEnd);
	
	            pripre_substr_replace($buff, $emStart, $k, 0);
	            $i += mb_strlen($emStart);
	            continue;
            }
            $op = mb_substr($buff, $i + 2, 3);
            switch($op) {
	            case "縦中横":
	           	$emStart = "<span class=\"_tcy\">";
	            $emEnd = "</span>";
	            pripre_substr_replace($buff, $emEnd, $i, ($j + 1) - $i);
	            $i += mb_strlen($emEnd);
	
	            pripre_substr_replace($buff, $emStart, $k, 0);
	            $i += mb_strlen($emStart);
	            continue;
            	            
	            case "無変換":
	           	$emStart = "<span class=\"_pre\">";
	            $emEnd = "</span>";
	            pripre_substr_replace($buff, $emEnd, $i, ($j + 1) - $i);
	            $i += mb_strlen($emEnd);
	
	            pripre_substr_replace($buff, $emStart, $k, 0);
	            $i += mb_strlen($emStart);
	            continue;
            	            
	            case "非表示":
	           	$emStart = "<span class=\"_hidden\">";
	            $emEnd = "</span>";
	            pripre_substr_replace($buff, $emEnd, $i, ($j + 1) - $i);
	            $i += mb_strlen($emEnd);
	
	            pripre_substr_replace($buff, $emStart, $k, 0);
	            $i += mb_strlen($emStart);
	            continue;
            }
        }
    }
    $buff = mb_ereg_replace('<p>[:space:]*([‘“（〔［｛〈《「『【⦅〖«〝])', '<p class="_noindent">\\1', $buff);
    }
    return implode("\n", $textarr);
}

// HTML整形
function pripre_formalize_filter($buff) {
    $doc = new DOMDocument();
    $doc->loadHTML("<?xml encoding=\"UTF-8\"><body id=\"ROOT\">$buff</body>");
    $node = $doc->getElementById("ROOT");
    $buff = $doc->saveXML($node);
    $buff = substr($buff, 16, strlen($buff) - 23);
    return $buff;
}

function pripre_ext2type($ext2type) {
	array_push($ext2type, array('image' => 'svg'));
	return $ext2type;
}

function pripre_mime_type($mimes) {
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
}
?>