/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.Report;
import java.util.ArrayList;

public class ValidationReport
implements Report {
    private int errorCount = 0;
    private int warningCount = 0;
    private int exceptionCount = 0;
    private ArrayList<ItemReport> errorList;
    private ArrayList<ItemReport> warningList;
    private ArrayList<ItemReport> exceptionList;
    public String fileName;
    String info = "";

    public ValidationReport(String file) {
        this.fileName = file;
        this.errorList = new ArrayList();
        this.warningList = new ArrayList();
        this.exceptionList = new ArrayList();
    }

    public ValidationReport(String file, String info) {
        this.fileName = file;
        if (!info.equals("")) {
            info = info + "\n";
        }
        this.info = info;
        this.errorList = new ArrayList();
        this.warningList = new ArrayList();
        this.exceptionList = new ArrayList();
    }

    @Override
    public void error(String resource, int line, int column, String message) {
        ++this.errorCount;
        ItemReport item = new ItemReport(resource, line, column, this.fixMessage(message));
        this.errorList.add(item);
    }

    @Override
    public void warning(String resource, int line, int column, String message) {
        ++this.warningCount;
        ItemReport item = new ItemReport(resource, line, column, this.fixMessage(message));
        this.warningList.add(item);
    }

    @Override
    public void exception(String resource, Exception e) {
        ++this.exceptionCount;
        ItemReport item = new ItemReport(resource, 0, 0, this.fixMessage(e.getMessage()));
        this.exceptionList.add(item);
    }

    public String toString() {
        ItemReport item;
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fileName + ": " + this.info);
        buffer.append("Errors: " + this.errorCount + "; Warnings: " + this.warningCount + "\n");
        for (i = 0; i < this.errorList.size(); ++i) {
            item = this.errorList.get(i);
            buffer.append("ERROR: " + this.fileName + (item.resource != null ? ":" + item.resource : "") + (item.line > 0 ? "(" + item.line + (item.column > 0 ? "," + item.column : "") + ")" : "") + ": " + item.message + "\n");
        }
        for (i = 0; i < this.warningList.size(); ++i) {
            item = this.warningList.get(i);
            buffer.append("WARNING: " + this.fileName + (item.resource != null ? ":" + item.resource : "") + (item.line > 0 ? "(" + item.line + (item.column > 0 ? "," + item.column : "") + ")" : "") + ": " + item.message + "\n");
        }
        for (i = 0; i < this.exceptionList.size(); ++i) {
            item = this.exceptionList.get(i);
            buffer.append("EXCEPTION: " + this.fileName + (item.resource != null ? ":" + item.resource : "") + item.message + "\n");
        }
        return buffer.toString();
    }

    private String fixMessage(String message) {
        return message.replaceAll("[\\s]+", " ");
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public int getExceptionCount() {
        return this.exceptionCount;
    }

    class ItemReport {
        String resource;
        int line;
        int column;
        String message;

        public ItemReport(String resource, int line, int column, String message) {
            this.resource = resource;
            this.line = line;
            this.column = column;
            this.message = message;
        }
    }
}

