/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.tool;

import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.EpubCheckFactory;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.nav.NavCheckerFactory;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.DocumentValidatorFactory;
import com.adobe.epubcheck.opf.OPFCheckerFactory;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.overlay.OverlayCheckerFactory;
import com.adobe.epubcheck.util.Archive;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FileResourceProvider;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.OPSType;
import com.adobe.epubcheck.util.URLResourceProvider;
import java.util.HashMap;

public class Checker {
    private static String path = null;
    private static String mode = null;
    private static EPUBVersion version = EPUBVersion.VERSION_3;
    private static OPSType opsType;
    private static boolean expanded;
    private static boolean keep;
    private static HashMap<OPSType, String> modeMimeTypeMap;
    private static HashMap<OPSType, DocumentValidatorFactory> documentValidatorFactoryMap;

    public static void validateFile(GenericResourceProvider resourceProvider, String fileName, String mimeType, EPUBVersion version, Report report) {
        opsType = new OPSType(mode, version);
        DocumentValidatorFactory factory = documentValidatorFactoryMap.get(opsType);
        if (factory == null) {
            System.out.println(Messages.DISPLAY_HELP);
            report.exception(fileName, new RuntimeException(String.format(Messages.MODE_VERSION_NOT_SUPPORTED, new Object[]{mode, version})));
            throw new RuntimeException(String.format(Messages.MODE_VERSION_NOT_SUPPORTED, new Object[]{mode, version}));
        }
        DocumentValidator check = factory.newInstance(report, path, resourceProvider, modeMimeTypeMap.get(opsType), version);
        if (check.validate()) {
            System.out.println(Messages.NO_ERRORS__OR_WARNINGS);
        } else {
            System.err.println(Messages.THERE_WERE_ERRORS);
        }
    }

    public static void validateFile(String path, String mimeType, EPUBVersion version, Report report) {
        GenericResourceProvider resourceProvider = path.startsWith("http://") || path.startsWith("https://") ? new URLResourceProvider(path) : new FileResourceProvider(path);
        opsType = new OPSType(mode, version);
        DocumentValidatorFactory factory = documentValidatorFactoryMap.get(opsType);
        if (factory == null) {
            System.out.println(Messages.DISPLAY_HELP);
            report.exception(path, new RuntimeException(String.format(Messages.MODE_VERSION_NOT_SUPPORTED, new Object[]{mode, version})));
            throw new RuntimeException(String.format(Messages.MODE_VERSION_NOT_SUPPORTED, new Object[]{mode, version}));
        }
        DocumentValidator check = factory.newInstance(report, path, resourceProvider, modeMimeTypeMap.get(opsType), version);
        if (check.validate()) {
            System.out.println(Messages.NO_ERRORS__OR_WARNINGS);
        } else {
            System.err.println(Messages.THERE_WERE_ERRORS);
        }
    }

    public static void main(String[] args) {
        Checker.processArguments(args);
        if (expanded) {
            Archive epub = new Archive(path, keep);
            DefaultReportImpl report = new DefaultReportImpl(epub.getEpubName());
            epub.createArchive();
            EpubCheck check = new EpubCheck(epub.getEpubFile(), (Report)report);
            if (check.validate()) {
                System.out.println(Messages.NO_ERRORS__OR_WARNINGS);
            } else {
                System.err.println(Messages.THERE_WERE_ERRORS);
            }
            return;
        }
        DefaultReportImpl report = mode != null ? new DefaultReportImpl(path, String.format(Messages.SINGLE_FILE, mode, version.toString())) : new DefaultReportImpl(path);
        Checker.validateFile(path, mode, version, report);
    }

    public static void processArguments(String[] args) {
        Checker.displayVersion();
        if (args.length < 1) {
            System.err.println(Messages.ARGUMENT_NEEDED);
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-version") || args[i].equals("-v")) {
                if (i + 1 < args.length) {
                    if (args[++i].equals("2.0") || args[i].equals("2")) {
                        version = EPUBVersion.VERSION_2;
                        continue;
                    }
                    if (args[i].equals("3.0") || args[i].equals("3")) {
                        version = EPUBVersion.VERSION_3;
                        continue;
                    }
                    System.out.println(Messages.DISPLAY_HELP);
                    throw new RuntimeException(new InvalidVersionException(InvalidVersionException.UNSUPPORTED_VERSION));
                }
                System.out.println(Messages.DISPLAY_HELP);
                throw new RuntimeException(String.format(Messages.AFTER_ARGUMENT_EXPECTED, "-v or -version", "version"));
            }
            if (args[i].equals("-mode")) {
                if (i + 1 < args.length) {
                    if (!(mode = args[++i]).equals("exp")) continue;
                    expanded = true;
                    continue;
                }
                System.out.println(Messages.DISPLAY_HELP);
                throw new RuntimeException(String.format(Messages.AFTER_ARGUMENT_EXPECTED, "-mode", "type"));
            }
            if (args[i].equals("-save")) {
                keep = true;
                continue;
            }
            if (args[i].equals("-help") || args[i].equals("-?")) {
                Checker.displayHelp();
                continue;
            }
            path = args[i];
        }
        if (path != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) == '\\') {
                    sb.append('/');
                    continue;
                }
                sb.append(path.charAt(i));
            }
            path = sb.toString();
        }
        if (path == null) {
            System.err.println(Messages.NO_FILE_SPECIFIED);
            System.err.println(Messages.END_OF_EXECUTION);
            System.exit(1);
        } else if (path.endsWith(".epub")) {
            if (mode != null || version != EPUBVersion.VERSION_3) {
                System.err.println(Messages.MODE_VERSION_IGNORED);
                mode = null;
            }
        } else if (mode == null) {
            throw new RuntimeException(Messages.MODE_REQUIRED);
        }
    }

    public static void displayHelp() {
        Checker.displayVersion();
        System.out.println("When running this tool, the first argument should be the name (with the path) of the file to check.");
        System.out.println("If checking a non-epub file, the epub version of the file must be specified using -v and the type of the file using -mode.");
        System.out.println("The default version is: 3.0.");
        System.out.println("Modes and versions supported: ");
        System.out.println("-mode opf -v 2.0");
        System.out.println("-mode opf -v 3.0");
        System.out.println("-mode xhtml -v 2.0");
        System.out.println("-mode xhtml -v 3.0");
        System.out.println("-mode svg -v 2.0");
        System.out.println("-mode svg -v 3.0");
        System.out.println("-mode nav -v 3.0");
        System.out.println("-mode mo  -v 3.0 // For MediaOverlay validation");
        System.out.println("-mode exp  // For expanded epubs archives");
        System.out.println("This tool also accepts the following flags:");
        System.out.println("-save \t= saves the epub created from the expended epub");
        System.out.println("-? or -help \t= displays this help message");
    }

    public static void displayVersion() {
        System.out.println("Epubcheck Version 3.0b2\n");
    }

    static {
        expanded = false;
        keep = false;
        HashMap<OPSType, Object> map = new HashMap<OPSType, Object>();
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_2), "application/xhtml+xml");
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_3), "application/xhtml+xml");
        map.put(new OPSType("svg", EPUBVersion.VERSION_2), "image/svg+xml");
        map.put(new OPSType("svg", EPUBVersion.VERSION_3), "image/svg+xml");
        map.put(new OPSType("mo", EPUBVersion.VERSION_3), "application/smil+xml");
        map.put(new OPSType("nav", EPUBVersion.VERSION_3), "nav");
        modeMimeTypeMap = map;
        map = new HashMap();
        map.put(new OPSType(null, EPUBVersion.VERSION_2), EpubCheckFactory.getInstance());
        map.put(new OPSType(null, EPUBVersion.VERSION_3), EpubCheckFactory.getInstance());
        map.put(new OPSType("opf", EPUBVersion.VERSION_2), OPFCheckerFactory.getInstance());
        map.put(new OPSType("opf", EPUBVersion.VERSION_3), OPFCheckerFactory.getInstance());
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_2), OPSCheckerFactory.getInstance());
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_3), OPSCheckerFactory.getInstance());
        map.put(new OPSType("svg", EPUBVersion.VERSION_2), OPSCheckerFactory.getInstance());
        map.put(new OPSType("svg", EPUBVersion.VERSION_3), OPSCheckerFactory.getInstance());
        map.put(new OPSType("mo", EPUBVersion.VERSION_3), OverlayCheckerFactory.getInstance());
        map.put(new OPSType("nav", EPUBVersion.VERSION_3), NavCheckerFactory.getInstance());
        documentValidatorFactoryMap = map;
    }
}

