package jp.cssj.cr.epub;

import jp.cssj.android.R;
import jp.cssj.print.epub.Contents;
import jp.cssj.print.epub.Contents.Item;
import jp.cssj.print.epub.EPubFile;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class SpineItemAdapter extends ArrayAdapter<Item> {
	private final EPubFile epub;
	private final Contents cs;

	public SpineItemAdapter(Context context, int textViewResourceId,
			EPubFile epub, Contents cs) {
		super(context, textViewResourceId, cs.spine);
		this.epub = epub;
		this.cs = cs;
	}

	public View getView(int position, View view, ViewGroup parent) {
		LayoutInflater inflater = (LayoutInflater) this.getContext()
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		try {
			if (view == null) {
				view = inflater.inflate(R.layout.spine_item, null);
			}
			Item item = this.cs.spine[position];
			String title = (position + 1) + " - ";
			if (item.title != null) {
				title += item.title;
			}
			TextView titleView = (TextView) view.findViewById(R.id.spineTitle);
			titleView.setText(title);
		} catch (Exception e) {
			Log.e(this.getClass().getName(), "EPUB error.", e);
		}

		return view;
	}
}
