/**
 * \brief Error code and helper module of CoolRain.
 *
 * Copyright (c) HATTORI, Hiroki
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#if !defined(COOLRAIN__ERROR__H__)
#define COOLRAIN__ERROR__H__

/** @{ \name Error codes */
#define COOLRAIN_SUCCESS		(0)	/*!< No error */
#define COOLRAIN_ERROR_NOMEM		(-1)	/*!< No memory */
#define COOLRAIN_ERROR_NOFILE		(-2)	/*!< No file exists */
#define COOLRAIN_ERROR_BAD_LENGTH	(-3)	/*!< Could'nt determine file length */
#define COOLRAIN_ERROR_CANT_READ	(-4)	/*!< Read error */
#define COOLRAIN_ERROR_PARSE_ERROR	(-5)	/*!< Parser erro (Syntax error on template) */
#define COOLRAIN_ERROR_INVALID_ARG	(-6)	/*!< Invalid argument(s) */
#define COOLRAIN_ERROR_BUFFER_FULL	(-7)	/*!< Destination buffer full */
#define COOLRAIN_ERROR_UNBUFFERED	(-8)	/*!< Target buffer is unbuffered */
#define COOLRAIN_ERROR_IO		(-9)	/*!< IO Error */
#define COOLRAIN_ERROR_RUNTIME		(-10)	/*!< Runtime error */
#define COOLRAIN_ERROR_NO_LOADER	(-11)	/*!< Template has no loader. (Loaded as standalone) */
#define COOLRAIN_ERROR_NO_ATTRIBUTE	(-12)	/*!< Missing required attribute */
/** @} */

#endif

