/**
 *
 */
#if !defined(COOLRAIN__FRAGMENT__H__)
#define COOLRAIN__FRAGMENT__H__


#include <glib/gmacros.h>
#include <CoolRain/refstring.h>

G_BEGIN_DECLS;

struct coolrain_tag_desc;


/*
 *
 */
#define COOLRAIN_FRAGMENT_ATTR_FLAGS_CSTRING	(1)

struct coolrain_fragment_attribute {
	struct coolrain_fragment_attribute *next;
	coolrain_refstring_t	name;
	coolrain_refstring_t	value;
	unsigned long		flags;
};




/*
 *
 */
typedef enum {
	COOLRAIN_FRAGMENT_TYPE_CONSTANT_STRING	= 0,
	COOLRAIN_FRAGMENT_TYPE_TAG		= 1,
	COOLRAIN_FRAGMENT_TYPE_VARREF		= 2,
} coolrain_fragment_type;






struct coolrain_fragment {
	struct coolrain_fragment	*next;
	coolrain_fragment_type		type;

	union {

		coolrain_refstring_t	str;
		coolrain_refstring_t	varname;

		struct {
			struct coolrain_tag_desc const	*tagdesc;
			struct coolrain_fragment_attribute *attrs;
			struct coolrain_fragment	*content;
		} tag;

	} data;
};


struct coolrain_fragment_attribute *coolrain_fragment_attribute_alloc(void);
void coolrain_fragment_attribute_free(struct coolrain_fragment_attribute *attrs);


struct coolrain_fragment *coolrain_fragment_alloc(coolrain_fragment_type type);
void coolrain_fragment_free(struct coolrain_fragment *fragment);

coolrain_refstring_t const *coolrain_fragment_find_attribute(struct coolrain_fragment const* __restrict fragment, char const * __restrict name);
char const* coolrain_fragment_find_attribute_as_cstring(struct coolrain_fragment const * __restrict fragment, char const * __restrict name);

G_END_DECLS;

#endif

