/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.socket;

import java.util.Vector;

import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.log.Log;
import junit.framework.TestCase;

public class TestSocketBasedPop3BaseImpl extends TestCase
{
	private SocketBasedPop3BaseImpl impl;
	private String userId="amanot";
	private String passwd="amax1180";
	private String serverName="mail.amax.co.jp";
	private int port=110;
	@Override
	protected void setUp() throws Exception
	{
		impl = new SocketBasedPop3BaseImpl();
		impl.setAccount(userId, passwd, serverName, null, port);
	}

	public void testGetUIDLList() throws Exception
	{
		Vector<UidlElement> rc = impl.getUIDLList();
		assertNotNull(rc);
		assertTrue(rc.size()>0);

		dumpUidl(rc);
	}
	
	public void testGetTopByUidlIndex() throws Exception
	{
		
		Vector<UidlElement> uidlList = impl.getUIDLList();
		int idx=67;
		String top = impl.getTopByUidlIndex(uidlList,idx);
		Log.debug(top);
		uidlList.add(0, new UidlElement("dummy", null));
		String top2 = impl.getTopByUidlIndex(uidlList,idx+1);
		Log.debug(top2);
		assertTrue(top.equals(top2));
		String top3 = impl.getTopByUidlIndex(uidlList,0);
		assertNull(top3);
	}
	
	public void testGetTopByUidl() throws Exception
	{
		
		Vector<UidlElement> uidlList = impl.getUIDLList();
		String uidl = uidlList.get(67).getUidl();
		String top = impl.getTopByUidl(uidlList,uidl);
		Log.debug(top);
		uidlList.add(0, new UidlElement("dummy", null));
		String top2 = impl.getTopByUidl(uidlList,uidl);
		Log.debug(top2);
		assertTrue(top.equals(top2));
		boolean gotException = false;
		try {
			impl.getTopByUidl(uidlList,"unyoraaaaaa111111111");
		}
		catch (IncorrectData id) {
			gotException=true;
		}
		assertTrue(gotException);
	}
	
	public void testGetRetrByUidlIndex() throws Exception
	{
		
		Vector<UidlElement> uidlList = impl.getUIDLList();
		int idx=67;
		String retr = impl.getRetrByUidlIndex(uidlList,idx);
		Log.debug(retr);
		uidlList.add(0, new UidlElement("dummy", null));
		String retr2 = impl.getRetrByUidlIndex(uidlList,idx+1);
		Log.debug(retr2);
		assertTrue(retr.equals(retr2));
		String retr3 = impl.getRetrByUidlIndex(uidlList,0);
		assertNull(retr3);
	}
	
	public void testGetRetrByUidl() throws Exception
	{
		
		Vector<UidlElement> uidlList = impl.getUIDLList();
		String uidl = uidlList.get(67).getUidl();
		String retr = impl.getRetrByUidl(uidlList,uidl);
		Log.debug(retr);
		uidlList.add(0, new UidlElement("dummy", null));
		String retr2 = impl.getRetrByUidl(uidlList,uidl);
		Log.debug(retr2);
		assertTrue(retr.equals(retr2));
		boolean gotException = false;
		try {
			impl.getRetrByUidl(uidlList,"unyoraaaaaa111111111");
		}
		catch (IncorrectData id) {
			gotException=true;
		}
		assertTrue(gotException);
	}

	private void dumpUidl(Vector<UidlElement> rc)
	{
		for (UidlElement uidl : rc) {
			Log.debug("UIDL:"+uidl.getUidl());
		}
	}
}
