/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.store;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Pop3ObjectIndexRawDataDateAndSubject
{
	private Date date;
	private String subject;
	
	public String toString()
	{
		return "Pop3ObjectIndexRawDataDateAndSubject."+subject.toString()+"/"+SimpleDateFormat.getInstance().format(date);
	}

	public boolean equals(Object obj)
	{
		if (obj==null) return false;
		if (!(obj instanceof Pop3ObjectIndexRawDataDateAndSubject)) return false;
		Pop3ObjectIndexRawDataDateAndSubject dst = (Pop3ObjectIndexRawDataDateAndSubject)obj;
		return (checkSubjectPart(dst.subject) && checkDatePart(dst.date));
	}

	private boolean checkSubjectPart(String dstStr)
	{
		if (this.subject==null) {
			if (dstStr==null) return true;
			return false;
		}
		return this.subject.equalsIgnoreCase(dstStr);
	}

	private boolean checkDatePart(Date dstDate)
	{
		if (this.date==null) {
			if (dstDate==null) return true;
			return false;
		}
		return this.date.equals(dstDate);
	}

	public Pop3ObjectIndexRawDataDateAndSubject(Date date, String subject)
	{
		super();
		this.date = date;
		this.subject = subject;
	}
	
	public Date getDate()
	{
		return date;
	}
	public void setDate(Date date)
	{
		this.date = date;
	}
	public String getSubject()
	{
		return subject;
	}
	public void setSubject(String subject)
	{
		this.subject = subject;
	}
}
