/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.store;

import java.util.Date;

import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.IObjectIndex;

public class Pop3ObjectIndex extends BasicObjectIndex
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public Pop3ObjectIndex()
	{
		super();
	}

	public Pop3ObjectIndex(Object arg0)
	{
		super(arg0);
	}

	public Pop3ObjectIndex(String messageID)
	{
		super(messageID);
	}
	
	public static Pop3ObjectIndexRawDataDateAndSubject makeIndexByDateAndSubject(Date date,String subject)
	{
		return new Pop3ObjectIndexRawDataDateAndSubject(date,subject);
	}

	public Pop3ObjectIndex(Pop3ObjectIndexRawDataDateAndSubject idx)
	{
		super(idx);
	}

	protected boolean typeValidation(Object arg0)
	{
		if (arg0 instanceof String) return true;
		if (arg0 instanceof Pop3ObjectIndexRawDataDateAndSubject) return true;
		return false;
	}

	public boolean equals(Object obj)
	{
		if (obj == null) return false;
		if (!(obj instanceof IObjectIndex)) return false;
		IObjectIndex dst = (IObjectIndex)obj;
		if (dst.getIndex()==null) return false;
		if (!this.getIndex().getClass().getName().endsWith(dst.getIndex().getClass().getName())) return false;
		if (this.getIndex() instanceof Pop3ObjectIndexRawDataDateAndSubject) {
			Pop3ObjectIndexRawDataDateAndSubject o1 = (Pop3ObjectIndexRawDataDateAndSubject)this.getIndex();
			Pop3ObjectIndexRawDataDateAndSubject o2 = (Pop3ObjectIndexRawDataDateAndSubject)dst.getIndex();
			return o1.equals(o2);
		}
		return super.equals(obj);
	}

}
