/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.store;

import java.io.*;
import java.util.*;

import javax.mail.*;
import javax.mail.internet.*;
import javax.mail.search.*;

//import jp.co.connectone.common.*;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.MailAddress;
import jp.co.connectone.store.*;

public abstract class EAIPop3Base
{
	private static final int DEFAULT_POP3_PORT = -1;
	protected int port = DEFAULT_POP3_PORT;
	
	public void finalize()
	{
		if (store != null) {
			close();
		}
	}
	
	protected void close()
	{
		if (store==null) return;
		try {
			if (folder!=null) {
				folder.close(false);
				folder = null;
			}
			store.close();
			store = null;
		}
		catch (MessagingException me) {
			Log.error("error closing pop3 store.", me);
		}
	}
	
	/**
	 * @param serverAddress serverAddress ݒB
	 */
	protected void setServerAddress(String serverAddress) throws ServerDown,HandleException
	{
		this.serverAddress = serverAddress;
	}

	protected Vector<HashMap<String,Object>> search(String storeURL,Vector<String> itemList,SearchConditionCollection conds) throws NullPointerException,ServerDown,HandleException
	{
		if (itemList==null) return null;
		if (userID==null) throw new NullPointerException("set userID first");
		if (password==null) throw new NullPointerException("set password first");
		if (serverAddress==null) throw new NullPointerException("set serverAddress first");

		Vector<HashMap<String,Object>> lists = new Vector<HashMap<String,Object>>();
		
		
		return lists;
	}
	
	protected Message[] getListByDate(String storeURL,Vector<String> itemList,Date date) throws NullPointerException, StoreNotFound,ServerDown,NoSuchRights,IncorrectStore,DataNotFound,IncorrectData, HandleException
	{
		if (userID==null) throw new NullPointerException("set userID first");
		if (serverAddress==null) throw new NullPointerException("set serverAddress first");
		Message[] list = null;
		Date date2 = null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY,0);
		cal.set(Calendar.MINUTE,0);
		cal.set(Calendar.SECOND,0);
		cal.set(Calendar.MILLISECOND,0);
		date = cal.getTime();
		cal.add(Calendar.DAY_OF_MONTH,1);
		date2 = cal.getTime();
		try {
			openFolder(Folder.READ_ONLY);
			list = folder.search(new AndTerm(new SentDateTerm(ComparisonTerm.GE,date),new SentDateTerm(ComparisonTerm.LT,date2)));
Log.debug("number of messages are "+ list.length);
		}
		catch (MessagingException me) {
			me.printStackTrace();
			throw new IncorrectStore(me.getMessage());
		}
		return list;
	}
	
	protected Message[] getList(String storeURL,Vector<String> itemList) throws NullPointerException, StoreNotFound,ServerDown,NoSuchRights,IncorrectStore,DataNotFound,IncorrectData, HandleException
	{
		if (itemList==null) return null;
		if (userID==null) throw new NullPointerException("set userID first");
		if (password==null) throw new NullPointerException("set password first");
		if (serverAddress==null) throw new NullPointerException("set serverAddress first");

		Message[] list = null;
		try {
			openFolder(Folder.READ_ONLY);
			list = folder.getMessages();
Log.debug("number of messages are "+ list.length);
		}
		catch (MessagingException me) {
			me.printStackTrace();
			throw new IncorrectStore(me.getMessage());
		}
		return list;
	}
	
	protected MimeMessage getMail(String messageID) throws NullPointerException,StoreNotFound,ServerDown,NoSuchRights,IncorrectStore,DataNotFound,IncorrectData, HandleException
	{
		if (userID==null) throw new NullPointerException("set userID first");
		if (password==null) throw new NullPointerException("set password first");
		if (serverAddress==null) throw new NullPointerException("set serverAddress first");
		MimeMessage msg = null;
		Message[] list = null;
		openFolder(Folder.READ_ONLY);
		try {
			list = folder.search(new MessageIDTerm(messageID));
Log.debug("number of messages are "+ list.length);
		}
		catch (MessagingException me) {
			me.printStackTrace();
			throw new IncorrectStore(me.getMessage());
		}
		msg = (MimeMessage)list[0];
		return msg;
	}
	
	protected MimeMessage getMail(Pop3ObjectIndexRawDataDateAndSubject dateAndSubject) throws NullPointerException,StoreNotFound,ServerDown,NoSuchRights,IncorrectStore,DataNotFound,IncorrectData, HandleException
	{
		if (userID==null) throw new NullPointerException("set userID first");
		if (password==null) throw new NullPointerException("set password first");
		if (serverAddress==null) throw new NullPointerException("set serverAddress first");
		MimeMessage msg = null;
		Message[] list = null;
		openFolder(Folder.READ_ONLY);
		try {
			list = folder.search(new ReceivedDateTerm(DateTerm.EQ,dateAndSubject.getDate()));
			list = folder.search(new SubjectTerm(dateAndSubject.getSubject()),list);
Log.debug("number of messages are "+ list.length);
		}
		catch (MessagingException me) {
			me.printStackTrace();
			throw new IncorrectStore(me.getMessage());
		}
		msg = (MimeMessage)list[0];
		return msg;
	}

	/**
	 * @param mode
	 * @throws IncorrectStore
	 */
	private void openFolder(int mode) throws IncorrectStore, HandleException
	{
		connect(serverAddress,port);
		if (folder == null) {
			try {
				folder = store.getFolder("INBOX");
				if (folder == null) {
					throw new IncorrectStore("store returns null folder");
				}
				folder.open(mode);
			}
			catch (MessagingException me) {
				me.printStackTrace();
				throw new IncorrectStore(me.getMessage());
			}
		}
	}
	
	protected int delete(String messageID) throws NullPointerException,HandleException
	{
		if (userID==null) throw new NullPointerException("set userID first");
		if (password==null) throw new NullPointerException("set password first");
		if (serverAddress==null) throw new NullPointerException("set serverAddress first");
		int mode = Folder.READ_WRITE;
		openFolder(mode);
		int code = 0;
		MimeMessage msg = null;
		try {
			msg = getMail(messageID);
			
		}
		catch (HandleException dnf) {
			Log.error("error on getting message.", dnf);
			return -1;
		}
		try {
			msg.setFlag(Flags.Flag.DELETED, true);
			folder.close(true);
			folder = null;
		}
		catch (MessagingException me) {
			Log.error("error on deleting mail.", me);
		}
		finally {
			close();
		}
		
		return code;
	}
	
	protected int delete(Pop3ObjectIndexRawDataDateAndSubject dateAndSubject) throws NullPointerException,HandleException
	{
		if (userID==null) throw new NullPointerException("set userID first");
		if (password==null) throw new NullPointerException("set password first");
		if (serverAddress==null) throw new NullPointerException("set serverAddress first");
		int mode = Folder.READ_WRITE;
		openFolder(mode);
		int code = 0;
		MimeMessage msg = null;
		try {
			msg = getMail(dateAndSubject);
			
		}
		catch (HandleException dnf) {
			Log.error("error on getting message.", dnf);
			return -1;
		}
		try {
			msg.setFlag(Flags.Flag.DELETED, true);
			folder.close(true);
			folder = null;
		}
		catch (MessagingException me) {
			Log.error("error on deleting mail.", me);
		}
		finally {
			close();
		}
		
		return code;
	}

	
/*---- getter/setter --------*/	
	private String serverAddress;
	private String path;
	private String userID;
	private String password;
	private String mailAddress;
	/**
	 * @return password ߂܂B
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * @param password password ݒB
	 */
	protected void setPassword(String password) {
		this.password = password;
	}
	/**
	 * @return path ߂܂B
	 */
	public String getPath() {
		return path;
	}
	/**
	 * @param path path ݒB
	 */
	protected void setPath(String path) {
		this.path = path;
	}
	/**
	 * @return serverAddress ߂܂B
	 */
	public String getServerAddress() {
		return serverAddress;
	}
	/**
	 * @return userID ߂܂B
	 */
	public String getUserID() {
		return userID;
	}
	/**
	 * @param userID userID ݒB
	 */
	protected void setUserID(String userID) {
		this.userID = userID;
	}
	
	@SuppressWarnings("unchecked")
	protected String getStringFromMessage(MimeMessage mmsg)
	{
		if (mmsg==null) return null;
		String msg = "";
		try {
			Enumeration<String> lines = mmsg.getAllHeaderLines();
			while (lines.hasMoreElements()) {
				msg = msg + lines.nextElement() + "\r\n";
			}
			msg = msg + "\r\n";
Log.trace("Header Line Dump\n============================\n"+msg);

			InputStream is = mmsg.getInputStream();
			BufferedReader b = new BufferedReader(new InputStreamReader(is));
			String tmp;
			while ((tmp = b.readLine())!=null) {
				msg = msg + tmp + "\r\n";
			}
		}
		catch (Exception e) {
			Log.error("Exception on creating MimeMessage",e);
			e.printStackTrace();
		}
		return msg;
	}

	protected String populateMessageFile(Hashtable<String,String> itemList)
	{
//		String msg = "content-class: urn:content-classes:message\r\n";
		String msg = "";
		String subject = itemList.get("urn:schemas:httpmail:subject");
		String body = itemList.get("urn:schemas:httpmail:textdescription");
		String from = itemList.get("urn:schemas:httpmail:sendername");
		if (from == null) {
			from = itemList.get("urn:schemas:httpmail:from");
		}
		
		try {
			MimeMessage mmsg = new MimeMessage((Session)null);
			MimeMultipart part = new MimeMultipart();
			MimeBodyPart pbody = new MimeBodyPart();

			pbody.setText(body,"UTF-8");
			part.addBodyPart(pbody);
			
			mmsg.setSubject(subject,"UTF-8");
			
			if (from != null) {
				MailAddress add = new MailAddress(from);
				String address = add.getAddressPart();
				String name = add.getNamePart();
				if (address.equals(name)) {
					mmsg.setFrom(new InternetAddress(address,name,"UTF-8"));
				}
				else {
					mmsg.setFrom(new InternetAddress(address));
				}
			}
			
			mmsg.setContent(part);
			mmsg.saveChanges();
			
			msg = getStringFromMessage(mmsg);
			
		}
		catch (Exception e) {
			Log.error("Exception on creating MimeMessage",e);
			e.printStackTrace();
		}

		
		return msg;
	}
	
	protected Store store = null;
	protected Folder folder = null;

	protected void connect(String server,int port) throws ServerDown,NoSuchRights,HandleException
	{
		if (store!=null) return;//already connected
		Properties props = new Properties();
//		props.put("mail.debug","true");
		Session session = Session.getDefaultInstance(props,null);
		try {
			store = session.getStore("pop3");
		}
		catch (NoSuchProviderException nspe) {
			nspe.printStackTrace();
			throw new HandleException(nspe);
		}
		try {
			store.connect(server,port,userID,password);
		}
		catch (MessagingException me) {
			me.printStackTrace();
			if (me instanceof AuthenticationFailedException) {
				throw new NoSuchRights(me.getMessage());
			}
			else {
				throw new ServerDown(me.getMessage());
			}
		}
	}

	public String getMailAddress() {
		return mailAddress;
	}

	protected FolderMetadata populateFolder(IFolderIndex idx)
	{
		FolderMetadata folder = new FolderMetadata();
		folder.setOid(idx);
		HashMap<String,Object> h = new HashMap<String,Object>();
		h.put("oid", idx);
		folder.setFieldSet(h);
		folder.setFolderName(idx.getIndex().toString());
		return folder;
	}
}
