/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.socket;

import java.io.*;
import java.util.ArrayList;

import javax.mail.*;
import javax.mail.internet.*;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.pim.*;

public class Pop3Translator
{
	public static MimeMessage TopString2MimeMessage(String topStr)
	{
		try {
			return new MimeMessage(null, new ByteArrayInputStream(topStr.getBytes()));
		}
		catch (MessagingException e) {
			Log.debug("error on creating MimeMessage.", e);
		}
		return null;
	}

	public static MimeMessage RetrString2MimeMessage(String retrStr)
	{
		return TopString2MimeMessage(retrStr);
	}

	public static IMailDTO TopString2MailDTO(String topStr, String uidl) throws HandleException {
		MimeMessage mes = TopString2MimeMessage(topStr);
		if (mes == null) return null;

		HeaderDTO header = TopString2HeaderDTO(topStr, uidl);
		IMailDTO mailDTOObj = new BasicMailDTO(header);
		try {
			// check attach
			if (mes.isMimeType("multipart/mixed")) {
				mailDTOObj.setAttachments(new AttachmentDTO[]{new AttachmentDTO()});// add attach mark
			}
		} catch (MessagingException e) {
			e.printStackTrace();
			if (!(e instanceof MessageRemovedException)) {
				throw new HandleException(e.getMessage());
			}
			Log.debug("skip this message...");
		}

		return mailDTOObj;
	}

	public static HeaderDTO TopString2HeaderDTO(String topStr, String uidl) throws HandleException
	{
		MimeMessage mes = TopString2MimeMessage(topStr);
		if (mes == null) return null;
		HeaderDTO head = new HeaderDTO();
		try {
			String tmp = null;
			head.setHeaderUIDL(uidl);
			head.setOid(new BasicObjectIndex(uidl));

			Address[] add = null;
			try {
				add = mes.getFrom();
			}
			catch (AddressException e) {
			}
			if (add != null) {
				tmp = add[0].toString();
				try {
					tmp = MimeUtility.decodeText(add[0].toString());
				}
				catch (UnsupportedEncodingException e) {
				}
				head.setHeaderFrom(tmp);
			}
			head.setHeaderSubject(mes.getSubject());
			int pri = 0;// 0=normal

			String priStr[] = mes.getHeader("importance");
			if (priStr == null) priStr = mes.getHeader("priority");
			try {
				if (priStr != null) pri = Integer.parseInt(priStr[0]);
			}
			catch (Exception e) {
			}
			;
			head.setHeaderPriority(pri);
			try {
				add = mes.getReplyTo();
			}
			catch (AddressException e) {
			}
			if (add != null) {
				tmp = add[0].toString();
				try {
					tmp = MimeUtility.decodeText(add[0].toString());
				}
				catch (UnsupportedEncodingException e) {
				}
				head.setHeaderReplyTo(tmp);
			}

			head.setHeaderSize(mes.getSize());
			head.setHeaderSendDate(mes.getSentDate());

			try {
				add = mes.getRecipients(Message.RecipientType.CC);
			}
			catch (AddressException e) {
			}
			if (add != null) {
				MailAddress[] cc = new MailAddress[add.length];
				for (int i = 0; i < add.length; i++) {
					tmp = add[i].toString();
					try {
						tmp = MimeUtility.decodeText(add[i].toString());
					}
					catch (UnsupportedEncodingException e) {
					}
					MailAddress address = new MailAddress(tmp);
					cc[i] = address;
				}
				head.setHeaderCC(cc);
			}
			try {
				add = mes.getRecipients(Message.RecipientType.TO);
			}
			catch (AddressException e) {
			}
			if (add != null) {
				MailAddress[] to = new MailAddress[add.length];
				for (int i = 0; i < add.length; i++) {
					tmp = add[i].toString();
					try {
						tmp = MimeUtility.decodeText(add[i].toString());
					}
					catch (UnsupportedEncodingException e) {
					}
					MailAddress address = new MailAddress(tmp);
					to[i] = address;
				}
				head.setHeaderTo(to);
			}
		}
		catch (MessagingException e) {
			e.printStackTrace();
			if (!(e instanceof MessageRemovedException)) {
				throw new HandleException(e.getMessage());
			}
			Log.debug("skip this message...");
		}

		return head;
	}

	public static IMailDTO RetrString2MailDTO(String retrStr, String uidl) throws HandleException
	{
		String bodyText=null;
		ArrayList<AttachmentDTO> attach=new ArrayList<AttachmentDTO>();
    	IMailDTO l_IMailDTOObj = new BasicMailDTO();
		HeaderDTO l_headerDTOObj = new HeaderDTO();
		String tmp = null;
		if (retrStr==null || retrStr.length() <= 0) {
			return l_IMailDTOObj;
		}

		MimeMessage mes = RetrString2MimeMessage(retrStr);
		try {
			l_headerDTOObj.setHeaderUIDL(uidl);
			l_headerDTOObj.setOid(new BasicObjectIndex(uidl));

			Address[] add = null;
			try {
				add = mes.getFrom();
			}
			catch(AddressException e){}
			if (add!=null) {
				tmp = add[0].toString();
				try {
					tmp =MimeUtility.decodeText(add[0].toString());
				}
				catch (UnsupportedEncodingException e) {}
				l_headerDTOObj.setHeaderFrom(tmp);
			}
			l_headerDTOObj.setHeaderSubject(mes.getSubject());
			int pri = 0;//0=normal
			
			String priStr[] = mes.getHeader("importance");
			if (priStr==null) priStr = mes.getHeader("priority");
			try {
				if (priStr!=null) pri = Integer.parseInt(priStr[0]);
			}
			catch(Exception e){};
			l_headerDTOObj.setHeaderPriority(pri);
			try {
				add = mes.getReplyTo();
			}
			catch(AddressException e){}
			if (add!=null) {
				tmp = add[0].toString();
				try {
					tmp =MimeUtility.decodeText(add[0].toString());
				}
				catch (UnsupportedEncodingException e) {}
				l_headerDTOObj.setHeaderReplyTo(tmp);
			}

			l_headerDTOObj.setHeaderSize(mes.getSize());
			l_headerDTOObj.setHeaderSendDate(mes.getSentDate());

			try {
				add = mes.getRecipients(Message.RecipientType.CC);
			}
			catch(AddressException e){}
			if (add != null) {
				MailAddress[] cc = new MailAddress[add.length];
				for (int i=0;i<add.length;i++) {
					tmp = add[i].toString();
					try {
						tmp =MimeUtility.decodeText(add[i].toString());
					}
					catch (UnsupportedEncodingException e) {}
					MailAddress address = new MailAddress(tmp);
					cc[i] = address;
				}
				l_headerDTOObj.setHeaderCC(cc);
			}
			try {
				add = mes.getRecipients(Message.RecipientType.TO);
			}
			catch(AddressException e){}
			if (add != null) {
				MailAddress[] to = new MailAddress[add.length];
				for (int i=0;i<add.length;i++) {
					tmp = add[i].toString();
					try {
						tmp =MimeUtility.decodeText(add[i].toString());
					}
					catch (UnsupportedEncodingException e) {}
					MailAddress address = new MailAddress(tmp);
					to[i] = address;
				}
				l_headerDTOObj.setHeaderTo(to);
			}
		}
		catch (MessagingException e) {
			e.printStackTrace();
			if (!(e instanceof MessageRemovedException)) {
				throw new HandleException(e.getMessage());
			}
			Log.debug("skip this message...");
		}
		l_IMailDTOObj.setHeaderDTO(l_headerDTOObj);

		bodyText = retrieveAllParts(mes, attach);
		try {
			bodyText = new String(bodyText.getBytes("Shift-JIS"),"MS932");
		}
		catch (Exception e){};
		l_IMailDTOObj.setBody(bodyText);
		
		if ((attach != null) &&(attach.size()>0)) {
			AttachmentDTO[] list = (AttachmentDTO[])attach.toArray((Object[])new AttachmentDTO[1]);
			l_IMailDTOObj.setAttachments(list);
			Log.debug(list.toString());
		}
		attach = null;

    	return l_IMailDTOObj;
	}
	
	private static String retrieveAllParts(Part part, ArrayList<AttachmentDTO> attach) throws IncorrectData,HandleException
	{
		String bodyText="";
		try {
			if (part.isMimeType("multipart/*")) {
				Multipart subPart = (Multipart)part.getContent();
				for (int i=0;i<subPart.getCount();i++) {
					String text = retrieveAllParts(subPart.getBodyPart(i), attach);
					if ((bodyText==null) || (bodyText.length()==0)) {
						bodyText = text;
					}
				}
			}
			else if (part.isMimeType("text/plain")) {
				if (part.getFileName()==null) {
					//{
					bodyText = (String)part.getContent();
				}
				else {
					//Yt
					addAttach(part,attach);
				}
			}
			else {
				//Yt
				addAttach(part, attach);
			}
			
		}
		catch (MessagingException me) {
			me.printStackTrace();
			throw new IncorrectData(me.getMessage());
		}
		catch (IOException ioe) {
			ioe.printStackTrace();
			throw new HandleException(ioe);
		}
		return bodyText;
	}

	private static void addAttach(Part part, ArrayList<AttachmentDTO> attach) throws MessagingException
	{
		AttachmentDTO newAttach = new AttachmentDTO();
		String fileName = null;
		byte[] rawData = null;
		try {
			fileName = part.getFileName();
		}
		catch (ParseException e) {
			
		}
		if (fileName==null) return;// noName contents like html-part of html-mail
		try {
			fileName =MimeUtility.decodeText(fileName);
			InputStream bio = part.getInputStream();
			ByteArrayOutputStream boo = new ByteArrayOutputStream();
			byte[] buf = new byte[81920];
			int len = buf.length;
			while (len == buf.length) {
				len = bio.read(buf);
				if (len<0) break;
				try {
					boo.write(buf,0,len);
				}
				catch (IndexOutOfBoundsException e) {
					Log.error("", e);
				}
			}
			rawData = boo.toByteArray();
		}
		catch (UnsupportedEncodingException e) {}
		catch (IOException ioe) {
			ioe.printStackTrace();
		}
		Log.debug(fileName);
		newAttach.setFileName(fileName);
		newAttach.setFileBody(rawData);
		attach.add(newAttach);
	}
}
