/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.socket;

import java.util.Date;

import jp.co.connectone.log.Log;

public class DateBinarySearch
{
    public enum MODE {GREATER,LESSER};

    public static int binarySearch(Date[] arr, Date d, MODE mode) {

        int l = 0;
        int r = arr.length - 1;
        int m;
        int val = -1;

        while (l <= r) {
            m = (l + r) / 2;

            Date from = arr[m];
            int comp = from.compareTo(d);

            if (comp < 0) {
                l = m + 1;
                val = m;
                Log.trace(">>");
                if (mode == MODE.GREATER)
                    val = val + 1;
            } else if (comp > 0) {
                r = m - 1;
                val = m;
                Log.trace("<<");
                if (mode == MODE.LESSER)
                    val = val - 1;
            } else {
                Log.trace("==");
                val = m;
                // Linear search.
                // There can be duplication of time.
                // Calculate the approximate value of the minimum difference.
                if (mode == MODE.GREATER) {
                    m = m - 1;
                    while (l <= m) {
                        from = arr[m];
                        comp = from.compareTo(d);
                        if (comp != 0) {
                            break;
                        }
                        val = m;
                        m = m - 1;
                    }
                } else if (mode == MODE.LESSER) {
                    m = m + 1;
                    while (r >= m) {
                        from = arr[m];
                        comp = from.compareTo(d);
                        if (comp != 0) {
                            break;
                        }
                        val = m;
                        m = m + 1;
                    }
                }
                break;
            }
        }
        return val;
    }

    public static boolean checkDataExist(int start,int end,Date[] arr)
    {
    	if (start<0) return false;
    	if (end<0) return false;
    	if (start>arr.length) return false;
    	if (start>end) return false;
        return true;
    }
}
