/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.ews.IEwsSearchFormula;
import jp.co.connectone.eai.exchews.ews.UpdateItemMap;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.*;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.ITaskDTO;
import jp.co.connectone.store.pim.ITaskStore;
import jp.co.connectone.user.*;

public class ExchewsTaskStoreImpl extends EAIExchewsBase implements ITaskStore
{
	public static final List<String> SEARCH_FIELDS = IEwsSearchFormula.ALL_PROPERTIES;
	public ExchewsTaskStoreImpl()
	{
		super();
		includeMimeContent=false;
	}

	public static final IStoreID storeID = new SimpleStoreID(ExchewsTaskStoreImpl.class.getName());
	public static final String storeName = "Exchange EWS task store";
	protected static final String itemType="IPM.Task";

	public String getName() throws Exception
	{
		return storeName;
	}
	
	public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception
	{
		return super.getServiceInfo(storeID, storeName, serviceData);
	}

	public IServiceInfo getServiceInfo() throws Exception
	{
		return new ExchewsServiceInfo(storeID,storeName);
	}

	public IStoreID getStoreID() throws Exception
	{
		return storeID;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.IStore#getPresetDestination(int)
	 */
	public ISearchDestination getPresetDestination(IAccountData acc,int type) throws IncorrectData, HandleException
	{
		super.setAccountData((PasswordBasedAccountDataImpl) acc);
		IFolderIndex folder = null;
		IDatabaseIndex db = null;
		DistinguishedFolderIdType src = new DistinguishedFolderIdType();
		switch (type) {
		case DEST_TYPE_DEFAULT_TASK_FOLDER:
			src.setId(taskElement);
			break;
		default:
			throw new IncorrectData("illegal folderType");
		}
		folder = (IFolderIndex) populateFolder(new ExchewsFolderIndex(src)).getOid();
		return (ISearchDestination) new BasicSearchDestination(db, folder);
	}

	@Override
	protected UnindexedFieldURIType getDateField()
	{
		return UnindexedFieldURIType.ITEM_DATE_TIME_CREATED;
	}

	@Override
	public IObjectIndex createNewTask(IAccountData acc, ITaskDTO dto) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException
	{
		super.setAccountData(acc);

		ItemType item = null;
		try {
			item = ExchewsTaskDTO.convertToTaskType(dto);
		}
		catch (Exception e) {
			Log.error("TaskDTO convert error.", e);
			throw new IncorrectData(e.getMessage());
		}
		item = super.createItem(taskElement, item);
		ExchewsObjectIndex oid = new ExchewsObjectIndex(item.getItemId());
		return oid;
	}

	@Override
	public void deleteTask(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		setAccountData((PasswordBasedAccountDataImpl)acc);
		super.delete(oid);
	}

	@Override
	public ITaskDTO[] getAllTasks(IAccountData acc) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		ExchewsTaskDTO[] l_taskDtoArray = new ExchewsTaskDTO[0];
		
		ISearchDestination dest = getPresetDestination(acc, DEST_TYPE_DEFAULT_TASK_FOLDER);
		List<String> fieldsToGet = SEARCH_FIELDS;
		
		List<? extends ItemType> items = new ArrayList<MessageType>();
		try {
			items = super.getList(dest, fieldsToGet);
		}
		catch (HandleException he) {
			throw he;
		}
		catch (Exception e) {
			Log.error("", e);
			throw new HandleException(e);
		}

		ArrayList<ExchewsTaskDTO> rc = new ArrayList<ExchewsTaskDTO>();
		for (ItemType item : items) {
			try {
				ExchewsTaskDTO dto = ExchewsTaskDTO.convertFromTaskType((TaskType)item);
				rc.add(dto);
				if (item.isHasAttachments().booleanValue()) {
//					dto.convertAndSetEWSAttachments(getAttachments(message));
				}
			}
			catch (Exception e) {
				Log.debug("error on converting MessageType to ExchewsMailDTO. skip one data..", e);
			}
		}

		return rc.toArray(l_taskDtoArray);
	}

	@Override
	public ITaskDTO getTaskByOID(IAccountData acc, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		super.setAccountData(acc);
		TaskType task = (TaskType) getItem(getPresetDestination(acc, DEST_TYPE_DEFAULT_TASK_FOLDER),(ItemIdType) oid.getIndex());
		ExchewsTaskDTO rc = null;
		try {
			rc = ExchewsTaskDTO.convertFromTaskType(task);
		}
		catch (HandleException he) {
			throw he;
		}
		catch (Exception e) {
			Log.error("mail convert error", e);
			throw new HandleException(e);
		}
		return rc;
	}

	@Override
	public ITaskDTO[] getTasksByDate(IAccountData acc, Date dateObj) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IObjectIndex updateTask(IAccountData acc, ITaskDTO dto) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException
	{
		if (dto==null) {
			throw new IncorrectData("dto null.");
		}
		if (dto.getOid()==null) {
			throw new IncorrectData("oid in updateItem should not be null");
		}
		super.setAccountData(acc);
		IObjectIndex oid = dto.getOid();

		super.updateItem((ItemIdType) oid.getIndex(),generateUpdateMap(dto));

		return oid;
	}

	protected UpdateItemMap generateUpdateMap(ITaskDTO dto) throws IncorrectData
	{
		UpdateItemMap map = new UpdateItemMap();
		
		ItemType item = null;
		try {
			item = new ItemType();
			item.setSubject(dto.getSubject());
			map.put(UnindexedFieldURIType.ITEM_SUBJECT, item);
			item = new ItemType();
			BodyType value = new BodyType();
			value.setBodyType(BodyTypeType.TEXT);
			value.setValue(dto.getBody());
			item.setBody(value);
			map.put(UnindexedFieldURIType.ITEM_BODY, item);
			
		}
		catch (Exception e) {
			Log.error("TaskDTO convert error.", e);
			throw new IncorrectData(e.getMessage());
		}
		
		return map;
	}

	@Override
	public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		this.deleteTask(acc, oid);
	}

	@Override
	public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception
	{
		if (data.isNew()) {
			return createNewTask(acc, (ITaskDTO) data);
		}
		else {
			return updateTask(acc, (ITaskDTO) data);
		}
	}

	@Override
	protected TargetFolderIdType getTargetFolder()
	{
		TargetFolderIdType target = new TargetFolderIdType();
		DistinguishedFolderIdType id = new DistinguishedFolderIdType();
		id.setId(taskElement);
		target.setDistinguishedFolderId(id);
		return target;
	}
}
