/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;

import jp.co.connectone.store.BasicObjectIndex;

/**
 * @author amanot
 *
 */
public class ExchewsObjectIndex extends BasicObjectIndex
{
	private static final long serialVersionUID = 1L;

	public ExchewsObjectIndex()
	{
		super();
	}

	/**
	 * @param arg0
	 */
	public ExchewsObjectIndex(Object arg0)
	{
		super(arg0);
	}

	@Override
	public String toString()
	{
		Object idx = getIndex();
		if (idx==null) return super.toString();
		if (idx instanceof ItemIdType) {
			ItemIdType i = (ItemIdType)getIndex();
			return i.getId();
		}
		if (idx instanceof String) {
			return (String)idx;
		}
		return idx.toString();
	}

	protected boolean typeValidation(Object obj)
	{
		if (obj instanceof ItemIdType) return true;
		return super.typeValidation(obj);
	}
}
