/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.ews;

import java.lang.reflect.Field;
import java.util.List;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;

public class EWSSearchFormula extends SearchFormulaBaseImpl implements IEwsSearchFormula
{
	protected static final String ALL_PROPERTIES_ELEMENT="IEwsSearchFormula.ALL_PROPERTIES";
	protected static final String PACKAGE_PREFIX="jp.co.connectone.eai.exchews.store.";
	protected EWSSearchFormula()
	{
		// for dummy :/
		super(null, null, null);
	}
	
	protected boolean validateFormat(String fieldName)
	{
		// format sample : "ExchewsMailDTO.datereceived"
		if (fieldName==null) return false;
		String[] elements = fieldName.split("\\.");
		if (elements.length!=2) return false;
		Class<?> o = null;
		try {
			o = Class.forName(PACKAGE_PREFIX + elements[0]);
			Class<?>[] c = o.getInterfaces();
			boolean contains=false;
			for (Class<?> type : c) {
				if (type.equals(IEwsDTOType.class)) {
					contains = true;
				}
			}
			if (!contains) {
				Log.trace("validateFormat:class interface vatidation error.");
			}
		}
		catch (Exception e) {
			Log.trace("validateFormat:classname vatidation error.");
			return false;
		}
		try {
			Field m = o.getDeclaredField(elements[1]);
			if (m ==null) {
				Log.trace("validateFormat:field "+elements[1]+" is null??");
			}
		}
		catch (Exception e) {
			Log.trace("validateFormat:fieldname vatidation error.");
			return false;
		}
		
		return true;
	}

	public EWSSearchFormula(ISearchDestination dest, List<String> fieldsToGet, SearchConditionCollection conditions) throws Exception
	{
		super(dest, fieldsToGet, conditions);
		
		if (searchDestinationValdation(dest)==false) {
			throw new HandleException("searchDestination valdation error.");
		}
		if (fieldsToGetValdation(fieldsToGet)==false) {
			throw new HandleException("fieldsToGet valdation error.");
		}
	}
	
	protected boolean searchDestinationValdation(ISearchDestination dest)
	{
		return true;
	}

	protected boolean fieldsToGetValdation(List<String> fieldsToGet)
	{
		if (ALL_PROPERTIES.equals(fieldsToGet)) return true;
		if (fieldsToGet == null) {
			Log.debug("EWSSearchFormula:fieldsToGet should not be null.");
			return false;
		}
		if (fieldsToGet.size()==0) {
			Log.debug("EWSSearchFormula:fieldsToGet should not be blank.");
			return false;
		}
		for (String field : fieldsToGet) {
			if (validateFormat(field)==false) {
				Log.debug("EWSSearchFormula:fieldsToGet validation error on "+field+".");
				return false;
			}
		}
		return true;
	};
	
	
}
